/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.services.mgt.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.config.CloudServiceConfig;
import org.apache.stratos.common.config.CloudServicesDescConfig;
import org.apache.stratos.common.config.PermissionConfig;
import org.apache.stratos.common.util.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.CarbonUtils;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static final String CONFIG_FILENAME = "cloud-services-desc.xml";
    private static RegistryService registryService;
    private static RealmService realmService;
    private static CloudServicesDescConfig cloudServicesDescConfig;

    public static synchronized void setRegistryService(RegistryService service) {
        if (registryService == null || service == null) {
            registryService = service;
        }
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static synchronized void setRealmService(RealmService service) {
        if (realmService == null || service == null) {
            realmService = service;
        }
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }

    public static RealmConfiguration getBootstrapRealmConfiguration() {
        return realmService.getBootstrapRealmConfiguration();
    }

    public static UserRegistry getTenantZeroSystemGovernanceRegistry() throws RegistryException {
        return registryService.getGovernanceSystemRegistry();
    }

    public static UserRegistry getSystemGovernanceRegistry(int tenantId) throws RegistryException {
        return registryService.getGovernanceSystemRegistry(tenantId);
    }

    public static UserRegistry getSystemConfigRegistry(int tenantId) throws RegistryException {
        return registryService.getConfigSystemRegistry(tenantId);
    }

    public static void loadCloudServicesConfiguration() throws Exception {
        OMElement configElement;
        String configFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + CONFIG_FILENAME;
        try {
            configElement = CommonUtil.buildOMElement((InputStream)new FileInputStream(configFileName));
        }
        catch (Exception e) {
            String msg = "Error in building the cloud service configuration. config filename: " + configFileName + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        cloudServicesDescConfig = new CloudServicesDescConfig(configElement);
    }

    public static CloudServicesDescConfig getCloudServicesDescConfig() {
        return cloudServicesDescConfig;
    }

    public static CloudServiceConfig getCloudServiceConfig(String cloudServiceName) {
        Map cloudServiceConfigs = cloudServicesDescConfig.getCloudServiceConfigs();
        return (CloudServiceConfig)cloudServiceConfigs.get(cloudServiceName);
    }

    public static void setCloudServiceActive(boolean active, String cloudServiceName, int tenantId) throws Exception {
        UserRegistry systemConfigRegistry;
        UserRegistry tenantZeroSystemGovernanceRegistry;
        CloudServiceConfig cloudServiceConfig = Util.getCloudServiceConfig(cloudServiceName);
        if (cloudServiceConfig.getLabel() == null) {
            return;
        }
        try {
            tenantZeroSystemGovernanceRegistry = Util.getTenantZeroSystemGovernanceRegistry();
            systemConfigRegistry = Util.getSystemConfigRegistry(tenantId);
        }
        catch (RegistryException e) {
            String msg = "Error in getting the tenant 0 system config registry";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        String cloudServiceInfoPath = "/repository/components/org.apache.stratos/cloud-manager/cloud-services/" + tenantId + "/" + cloudServiceName;
        Object cloudServiceInfoResource = tenantZeroSystemGovernanceRegistry.resourceExists(cloudServiceInfoPath) ? tenantZeroSystemGovernanceRegistry.get(cloudServiceInfoPath) : tenantZeroSystemGovernanceRegistry.newCollection();
        cloudServiceInfoResource.setProperty("active", active ? "true" : "false");
        tenantZeroSystemGovernanceRegistry.put(cloudServiceInfoPath, (Resource)cloudServiceInfoResource);
        List permissionConfigs = cloudServiceConfig.getPermissionConfigs();
        for (PermissionConfig permissionConfig : permissionConfigs) {
            String path = permissionConfig.getPath();
            String name = permissionConfig.getName();
            if (active) {
                if (systemConfigRegistry.resourceExists(path)) continue;
                Collection collection = systemConfigRegistry.newCollection();
                collection.setProperty("name", name);
                systemConfigRegistry.put(path, (Resource)collection);
                continue;
            }
            if (!systemConfigRegistry.resourceExists(path)) continue;
            systemConfigRegistry.delete(path);
        }
    }

    public static boolean isCloudServiceActive(String cloudServiceName, int tenantId) throws Exception {
        UserRegistry systemGovernanceRegistry;
        try {
            systemGovernanceRegistry = Util.getTenantZeroSystemGovernanceRegistry();
        }
        catch (RegistryException e) {
            String msg = "Error in getting the tenant 0 system config registry";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        String cloudServiceInfoPath = "/repository/components/org.apache.stratos/cloud-manager/cloud-services/" + tenantId + "/" + cloudServiceName;
        if (systemGovernanceRegistry.resourceExists(cloudServiceInfoPath)) {
            Resource cloudServiceInfoResource = systemGovernanceRegistry.get(cloudServiceInfoPath);
            String isActiveStr = cloudServiceInfoResource.getProperty("active");
            return "true".equals(isActiveStr);
        }
        return false;
    }

    public static void loadServiceIcons() throws Exception {
        String serviceIconDirLocation = CarbonUtils.getCarbonHome() + "/resources/cloud-service-icons";
        File serviceIconDirDir = new File(serviceIconDirLocation);
        UserRegistry registry = Util.getTenantZeroSystemGovernanceRegistry();
        try {
            HashMap<String, String> extensionToMediaTypeMap = new HashMap<String, String>();
            extensionToMediaTypeMap.put("gif", "img/gif");
            extensionToMediaTypeMap.put("jpg", "img/gif");
            extensionToMediaTypeMap.put("png", "img/png");
            File[] filesAndDirs = serviceIconDirDir.listFiles();
            if (filesAndDirs == null) {
                return;
            }
            List<File> filesDirs = Arrays.asList(filesAndDirs);
            for (File file : filesDirs) {
                String filename = file.getName();
                String fileRegistryPath = "/repository/components/org.apache.stratos/cloud-manager/cloud-services-icons/" + filename;
                Resource newResource = registry.newResource();
                String mediaType = null;
                if (filename.contains(".")) {
                    String fileExt = filename.substring(filename.lastIndexOf(".") + 1);
                    mediaType = (String)extensionToMediaTypeMap.get(fileExt.toLowerCase());
                }
                if (mediaType == null) {
                    mediaType = new MimetypesFileTypeMap().getContentType(file);
                }
                newResource.setMediaType(mediaType);
                newResource.setContentStream((InputStream)new FileInputStream(file));
                registry.put(fileRegistryPath, newResource);
            }
        }
        catch (Exception e) {
            String msg = "Error loading icons to the system registry for registry path: /repository/components/org.apache.stratos/cloud-manager/cloud-services-icons";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        try {
            CommonUtil.setAnonAuthorization((String)"/_system/governance/repository/components/org.apache.stratos/cloud-manager/cloud-services-icons", (UserRealm)registry.getUserRealm());
        }
        catch (RegistryException e) {
            String msg = "Setting the annon access enabled for the services icons paths.";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    static {
        cloudServicesDescConfig = null;
    }
}

