/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.keystore.mgt;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.keystore.mgt.KeyStoreMgtException;
import org.apache.stratos.keystore.mgt.util.RealmServiceHolder;
import org.apache.stratos.keystore.mgt.util.RegistryServiceHolder;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class KeyStoreGenerator {
    private static Log log = LogFactory.getLog(KeyStoreGenerator.class);
    private UserRegistry govRegistry;
    private int tenantId;
    private String tenantDomain;
    private String password;

    public KeyStoreGenerator(int tenantId) throws KeyStoreMgtException {
        try {
            this.tenantId = tenantId;
            this.tenantDomain = this.getTenantDomainName();
            this.govRegistry = RegistryServiceHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
            if (this.govRegistry == null) {
                log.error((Object)"Governance registry instance is null");
                throw new KeyStoreMgtException("Governance registry instance is null");
            }
        }
        catch (RegistryException e) {
            String errorMsg = "Error while obtaining the governance registry for tenant : " + tenantId;
            log.error((Object)errorMsg, (Throwable)e);
            throw new KeyStoreMgtException(errorMsg, e);
        }
    }

    public void generateKeyStore() throws KeyStoreMgtException {
        try {
            this.password = this.generatePassword();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, this.password.toCharArray());
            X509Certificate pubCert = this.generateKeyPair(keyStore);
            this.persistKeyStore(keyStore, pubCert);
        }
        catch (Exception e) {
            String msg = "Error while instantiating a keystore";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }

    private X509Certificate generateKeyPair(KeyStore keyStore) throws KeyStoreMgtException {
        try {
            CryptoUtil.getDefaultCryptoUtil();
            KeyPairGenerator keyPairGenerator = null;
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            String commonName = "CN=" + this.tenantDomain + ", OU=None, O=None L=None, C=None";
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            v3CertGen.setSerialNumber(BigInteger.valueOf(new SecureRandom().nextInt()));
            v3CertGen.setIssuerDN((X509Name)new X509Principal(commonName));
            v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
            v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
            v3CertGen.setSubjectDN((X509Name)new X509Principal(commonName));
            v3CertGen.setPublicKey(keyPair.getPublic());
            v3CertGen.setSignatureAlgorithm("MD5WithRSAEncryption");
            X509Certificate PKCertificate = v3CertGen.generateX509Certificate(keyPair.getPrivate());
            keyStore.setKeyEntry(this.tenantDomain, keyPair.getPrivate(), this.password.toCharArray(), new Certificate[]{PKCertificate});
            return PKCertificate;
        }
        catch (Exception ex) {
            String msg = "Error while generating the certificate for tenant :" + this.tenantDomain + ".";
            log.error((Object)msg, (Throwable)ex);
            throw new KeyStoreMgtException(msg, ex);
        }
    }

    private void persistKeyStore(KeyStore keyStore, X509Certificate PKCertificate) throws KeyStoreMgtException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            keyStore.store(outputStream, this.password.toCharArray());
            outputStream.flush();
            outputStream.close();
            String keyStoreName = this.generateKSNameFromDomainName();
            KeyStoreAdmin keystoreAdmin = new KeyStoreAdmin(this.tenantId, (Registry)this.govRegistry);
            keystoreAdmin.addKeyStore(outputStream.toByteArray(), keyStoreName, this.password, " ", "JKS", this.password);
            Resource pubKeyResource = this.govRegistry.newResource();
            pubKeyResource.setContent((Object)PKCertificate.getEncoded());
            pubKeyResource.addProperty("tenant.pub.key.file.name.appender", this.generatePubKeyFileNameAppender());
            this.govRegistry.put("/repository/security/pub-key", pubKeyResource);
            this.govRegistry.addAssociation("/repository/security/key-stores/" + keyStoreName, "/repository/security/pub-key", "assoc.tenant.ks.pub.key");
        }
        catch (RegistryException e) {
            String msg = "Error when writing the keystore/pub.cert to registry";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
        catch (Exception e) {
            String msg = "Error when processing keystore/pub. cert to be stored in registry";
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }

    private String generatePassword() {
        SecureRandom random = new SecureRandom();
        String randString = new BigInteger(130, random).toString(12);
        return randString.substring(randString.length() - 10, randString.length());
    }

    private String generatePubKeyFileNameAppender() {
        String uuid = UUIDGenerator.getUUID();
        return uuid.substring(uuid.length() - 6, uuid.length() - 1);
    }

    private String generateKSNameFromDomainName() {
        String ksName = this.tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }

    private String getTenantDomainName() throws KeyStoreMgtException {
        RealmService realmService = RealmServiceHolder.getRealmService();
        if (realmService == null) {
            String msg = "Error in getting the domain name, realm service is null.";
            log.error((Object)msg);
            throw new KeyStoreMgtException(msg);
        }
        try {
            return realmService.getTenantManager().getDomain(this.tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in getting the domain name for the tenant id: " + this.tenantId;
            log.error((Object)msg, (Throwable)e);
            throw new KeyStoreMgtException(msg, e);
        }
    }
}

