/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.email.sender.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailSenderConfiguration {
    private static Log log = LogFactory.getLog(EmailSenderConfiguration.class);
    public static final String DEFAULT_VALUE_SUBJECT = "EmailSender";
    public static final String DEFAULT_VALUE_MESSAGE = "Sent form WSO2 Carbon";
    private String fromEmail;
    private String subject = "EmailSender";
    private String body = "Sent form WSO2 Carbon";
    private Map<String, String> customParameters;

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject.trim();
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String emailMessage) {
        this.body = emailMessage.trim();
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmailSenderConfiguration loadEmailSenderConfiguration(String configFilename) {
        File configFile = new File(configFilename);
        if (!configFile.exists()) {
            log.error((Object)("Email sender configuration File is not present at: " + configFilename));
            return null;
        }
        EmailSenderConfiguration config = new EmailSenderConfiguration();
        FileInputStream ip = null;
        try {
            ip = new FileInputStream(configFile);
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(ip);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement documentElement = builder.getDocumentElement();
            Iterator it = documentElement.getChildElements();
            while (it.hasNext()) {
                OMElement element = (OMElement)it.next();
                if ("subject".equals(element.getLocalName())) {
                    config.setSubject(element.getText());
                    continue;
                }
                if ("body".equals(element.getLocalName())) {
                    config.setBody(element.getText());
                    continue;
                }
                if (!"customParameters".equals(element.getLocalName())) continue;
                HashMap<String, String> customParameters = new HashMap<String, String>();
                Iterator customParamIt = element.getChildElements();
                while (customParamIt.hasNext()) {
                    OMElement customElement = (OMElement)it.next();
                    customParameters.put(customElement.getLocalName(), customElement.getText());
                }
                config.setCustomParameters(customParameters);
            }
            EmailSenderConfiguration emailSenderConfiguration = config;
            return emailSenderConfiguration;
        }
        catch (Exception e) {
            String msg = "Error in loading configuration for email verification: " + configFilename + ".";
            log.error((Object)msg, (Throwable)e);
            EmailSenderConfiguration emailSenderConfiguration = null;
            return emailSenderConfiguration;
        }
        finally {
            if (ip != null) {
                try {
                    ip.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close InputStream for file " + configFile.getAbsolutePath()));
                }
            }
        }
    }
}

