/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.paypal.integration;

import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.services.CallerServices;
import com.paypal.soap.api.AbstractRequestType;
import com.paypal.soap.api.AbstractResponseType;
import com.paypal.soap.api.AckCodeType;
import org.wso2.carbon.business.messaging.paypal.integration.AbstractProxy;

public class PaypalSOAPProxy
extends AbstractProxy {
    private CallerServices caller = new CallerServices();
    private AbstractRequestType request;
    private AbstractResponseType response;

    private PaypalSOAPProxy(APIProfile profile) throws PayPalException {
        super(profile);
        this.caller.setAPIProfile(profile);
    }

    private PaypalSOAPProxy(String apiUsername, String apiPassword) throws PayPalException {
        this(apiUsername, apiPassword, null);
    }

    private PaypalSOAPProxy(String apiUsername, String apiPassword, String apiSignature) throws PayPalException {
        super(apiUsername, apiPassword, apiSignature);
        this.caller.setAPIProfile(this.profile);
    }

    private void setRequest(AbstractRequestType request) {
        this.request = request;
        this.request.setVersion(this.version);
    }

    private void setOperation(String operation) {
        this.operation = operation;
    }

    public AbstractResponseType call(String operation, AbstractRequestType request) throws PayPalException {
        this.response = this.caller.call(operation, request);
        return this.response;
    }

    public AbstractResponseType call(String operation) throws PayPalException {
        return null;
    }

    public boolean isSuccess() {
        return this.response != null && this.response.getAck().equals(AckCodeType.Success) || this.response.getAck().equals(AckCodeType.SuccessWithWarning);
    }

    public static PaypalSOAPProxy createPaypalSOAPProxy(APIProfile profile) throws PayPalException {
        return new PaypalSOAPProxy(profile);
    }

    public static PaypalSOAPProxy createPaypalSOAPProxy(String apiUsername, String apiPassword) throws PayPalException {
        return new PaypalSOAPProxy(apiUsername, apiPassword);
    }

    public static PaypalSOAPProxy createPaypalSOAPProxy(String apiUsername, String apiPassword, String apiSignature) throws PayPalException {
        return new PaypalSOAPProxy(apiUsername, apiPassword, apiSignature);
    }
}

