/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.util.converters;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class CalendarConverter
implements Converter {
    private static DateFormat df = DateFormat.getDateInstance(3);

    public boolean canConvert(Class type) {
        return type.equals(GregorianCalendar.class);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(df.format(((Calendar)source).getTime()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(df.parse(reader.getValue()));
        }
        catch (Exception e) {
            // empty catch block
        }
        return calendar;
    }

    public static Calendar convertToCalendar(String date) {
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(df.parse(date));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }
}

