/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Cookable;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.enumerator.EnumeratorSet;

public class SimpleCompiler
extends Cookable {
    private static final boolean DEBUG = false;
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    private Class[] optionalAuxiliaryClasses = null;
    private AuxiliaryClassLoader classLoader = null;
    private IClassLoader iClassLoader = null;
    private ClassLoader result = null;
    public static final ClassLoader BOOT_CLASS_LOADER = new ClassLoader(null){};
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$org$codehaus$janino$SimpleCompiler;

    public SimpleCompiler() {
    }

    public SimpleCompiler(String string) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.cookFile(string);
    }

    public SimpleCompiler(String string, InputStream inputStream) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.cook(string, inputStream);
    }

    public SimpleCompiler(String string, Reader reader) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.cook(string, reader);
    }

    public SimpleCompiler(Scanner scanner, ClassLoader classLoader) throws IOException, Scanner.ScanException, Parser.ParseException, CompileException {
        this.setParentClassLoader(classLoader);
        this.cook(scanner);
    }

    protected void assertNotCooked() {
        if (this.classLoader != null) {
            throw new IllegalStateException("Already cooked");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Java.Type classToType(Location location, Class clazz) {
        IClass iClass;
        if (clazz == null) {
            return null;
        }
        this.classLoader.addAuxiliaryClass(clazz);
        try {
            iClass = this.iClassLoader.loadIClass(Descriptor.fromClassName(clazz.getName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Loading IClass \"" + clazz.getName() + "\": " + classNotFoundException);
        }
        if (iClass == null) {
            throw new RuntimeException("Cannot load class \"" + clazz.getName() + "\" through the given ClassLoader");
        }
        return new Java.SimpleType(location, iClass);
    }

    protected Java.Type[] classesToTypes(Location location, Class[] classArray) {
        Java.Type[] typeArray = new Java.Type[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            typeArray[n] = this.classToType(location, classArray[n]);
            ++n;
        }
        return typeArray;
    }

    protected final ClassLoader compileToClassLoader(Java.CompilationUnit compilationUnit, EnumeratorSet enumeratorSet) throws CompileException {
        ClassFile[] classFileArray = new UnitCompiler(compilationUnit, this.iClassLoader).compileUnit(enumeratorSet);
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        int n = 0;
        while (n < classFileArray.length) {
            ClassFile classFile = classFileArray[n];
            hashMap.put(classFile.getThisClassName(), classFile.toByteArray());
            ++n;
        }
        this.result = new ByteArrayClassLoader(hashMap, (ClassLoader)this.classLoader);
        return this.result;
    }

    public void cook(Java.CompilationUnit compilationUnit) throws CompileException {
        this.setUpClassLoaders();
        this.compileToClassLoader(compilationUnit, DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION);
    }

    public void cook(Scanner scanner) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException {
        this.setUpClassLoaders();
        Java.CompilationUnit compilationUnit = new Parser(scanner).parseCompilationUnit();
        this.compileToClassLoader(compilationUnit, DebuggingInformation.DEFAULT_DEBUGGING_INFORMATION);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimpleCompiler)) {
            return false;
        }
        SimpleCompiler simpleCompiler = (SimpleCompiler)object;
        if (this.getClass() != simpleCompiler.getClass()) {
            return false;
        }
        if (this.result == null || simpleCompiler.result == null) {
            throw new IllegalStateException("Equality can only be checked after cooking");
        }
        return this.result.equals(simpleCompiler.result);
    }

    public ClassLoader getClassLoader() {
        if (this.getClass() != (class$org$codehaus$janino$SimpleCompiler != null ? class$org$codehaus$janino$SimpleCompiler : (class$org$codehaus$janino$SimpleCompiler = SimpleCompiler.class$("org.codehaus.janino.SimpleCompiler")))) {
            throw new IllegalStateException("Must not be called on derived instances");
        }
        if (this.result == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return this.result;
    }

    public int hashCode() {
        return this.classLoader.hashCode();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length >= 1 && stringArray[0].equals("-help")) {
            System.out.println("Usage:");
            System.out.println("    org.codehaus.janino.SimpleCompiler <source-file> <class-name> { <argument> }");
            System.out.println("Reads a compilation unit from the given <source-file> and invokes method");
            System.out.println("\"public static void main(String[])\" of class <class-name>, passing the.");
            System.out.println("given <argument>s.");
            System.exit(1);
        }
        if (stringArray.length < 2) {
            System.err.println("Source file and/or class name missing; try \"-help\".");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String[] stringArray2 = new String[stringArray.length - 2];
        System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        ClassLoader classLoader = new SimpleCompiler(string, new FileInputStream(string)).getClassLoader();
        Class<?> clazz = classLoader.loadClass(string2);
        Method method = clazz.getMethod("main", array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = SimpleCompiler.class$("[Ljava.lang.String;")));
        method.invoke(null, new Object[]{stringArray2});
    }

    public void setParentClassLoader(ClassLoader classLoader) {
        this.setParentClassLoader(classLoader, null);
    }

    public void setParentClassLoader(ClassLoader classLoader, Class[] classArray) {
        this.assertNotCooked();
        this.parentClassLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        this.optionalAuxiliaryClasses = classArray;
    }

    protected final void setUpClassLoaders() {
        this.assertNotCooked();
        class Org_codehaus_janino_SimpleCompiler$2 {
            /* synthetic */ Org_codehaus_janino_SimpleCompiler$2() {
            }
        }
        this.classLoader = new AuxiliaryClassLoader(null, this.parentClassLoader);
        if (this.optionalAuxiliaryClasses != null) {
            int n = 0;
            while (n < this.optionalAuxiliaryClasses.length) {
                this.classLoader.addAuxiliaryClass(this.optionalAuxiliaryClasses[n]);
                ++n;
            }
        }
        this.iClassLoader = new ClassLoaderIClassLoader(this.classLoader);
    }

    private static final class AuxiliaryClassLoader
    extends ClassLoader {
        private final Map auxiliaryClasses = new HashMap();

        private AuxiliaryClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        /* synthetic */ AuxiliaryClassLoader(2 var1_1, ClassLoader classLoader) {
            this(classLoader);
        }

        private void addAuxiliaryClass(Class clazz) {
            Class<Object> clazz2;
            if (this.auxiliaryClasses.containsKey(clazz.getName())) {
                return;
            }
            try {
                clazz2 = super.loadClass(clazz.getName(), false);
                if (clazz2 != clazz) {
                    throw new RuntimeException("Trying to add an auxiliary class \"" + clazz.getName() + "\" while another class with the same name is already loaded");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            this.auxiliaryClasses.put(clazz.getName(), clazz);
            clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                this.addAuxiliaryClass(clazz2);
            }
            Class<?>[] classArray = clazz.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                this.addAuxiliaryClass(classArray[n]);
                ++n;
            }
        }

        public boolean equals(Object object) {
            AuxiliaryClassLoader auxiliaryClassLoader;
            block7: {
                block5: {
                    boolean bl;
                    block6: {
                        ClassLoader classLoader;
                        ClassLoader classLoader2;
                        block4: {
                            if (!(object instanceof AuxiliaryClassLoader)) {
                                return false;
                            }
                            auxiliaryClassLoader = (AuxiliaryClassLoader)object;
                            classLoader2 = this.getParent();
                            classLoader = auxiliaryClassLoader.getParent();
                            if (classLoader2 != null) break block4;
                            if (classLoader != null) break block5;
                            bl = false;
                            break block6;
                        }
                        bl = classLoader2.equals(classLoader) ^ true;
                    }
                    if (!bl) break block7;
                }
                return false;
            }
            return this.auxiliaryClasses.equals(auxiliaryClassLoader.auxiliaryClasses);
        }

        public int hashCode() {
            ClassLoader classLoader = this.getParent();
            return (classLoader == null ? 0 : classLoader.hashCode()) ^ this.auxiliaryClasses.hashCode();
        }

        protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class clazz = (Class)this.auxiliaryClasses.get(string);
            if (clazz != null) {
                return clazz;
            }
            return super.loadClass(string, bl);
        }
    }
}

