/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.account.mgt.services;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.account.mgt.beans.AccountInfoBean;
import org.apache.stratos.account.mgt.util.Util;
import org.apache.stratos.common.beans.TenantInfoBean;
import org.apache.stratos.common.util.ClaimsMgtUtil;
import org.apache.stratos.common.util.CommonUtil;
import org.apache.stratos.tenant.mgt.util.TenantMgtUtil;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.Tenant;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class AccountMgtService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(AccountMgtService.class);

    public void updateContact(String contactEmail) throws Exception {
        Tenant tenant;
        EmailVerifcationSubscriber emailverifier = Util.getEmailVerificationService();
        TenantManager tenantManager = Util.getTenantManager();
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        if (registry == null) {
            String msg = "Error in retrieving the registry for the login tenant.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        int tenantId = registry.getTenantId();
        try {
            tenant = (Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information for the tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        String confirmationKey = UUIDGenerator.generateUUID();
        UserRegistry superTenantSystemRegistry = Util.getGovernanceSystemRegistry(-1234);
        String emailVerificationPath = "/repository/components/org.wso2.carbon.email-confirmation-flag/" + tenantId;
        Resource resource = superTenantSystemRegistry.resourceExists(emailVerificationPath) ? superTenantSystemRegistry.get(emailVerificationPath) : superTenantSystemRegistry.newResource();
        resource.setContent((Object)confirmationKey);
        superTenantSystemRegistry.put(emailVerificationPath, resource);
        try {
            HashMap<String, String> datatostore = new HashMap<String, String>();
            datatostore.put("first-name", ClaimsMgtUtil.getFirstName((RealmService)Util.getRealmService(), (int)tenantId));
            datatostore.put("email", contactEmail);
            datatostore.put("userName", tenant.getAdminName());
            datatostore.put("tenantDomain", tenant.getDomain());
            datatostore.put("confirmationKey", confirmationKey);
            emailverifier.requestUserVerification(datatostore, Util.getEmailVerifierConfig());
        }
        catch (Exception e) {
            String msg = "Error in adding tenant, tenant domain: " + tenant.getDomain() + ".";
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public String getContact() throws Exception {
        Tenant tenant;
        TenantManager tenantManager = Util.getTenantManager();
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        if (registry == null) {
            String msg = "Error in retrieving the registry for the login tenant.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        int tenantId = registry.getTenantId();
        try {
            tenant = (Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information for the tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return tenant.getEmail();
    }

    public boolean updateFullname(AccountInfoBean accountInfoBean) throws Exception {
        Tenant tenant;
        TenantManager tenantManager = Util.getTenantManager();
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        if (registry == null) {
            String msg = "Error in retrieving the registry for the login tenant.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        int tenantId = registry.getTenantId();
        try {
            tenant = (Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information for the tenant id: " + tenantId + ".";
            log.info((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        RealmService realmService = Util.getRealmService();
        try {
            HashMap<String, String> claimsMap = new HashMap<String, String>();
            claimsMap.put("http://wso2.org/claims/givenname", accountInfoBean.getFirstname());
            claimsMap.put("http://wso2.org/claims/lastname", accountInfoBean.getLastname());
            UserStoreManager userStoreManager = (UserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            userStoreManager.setUserClaimValues(ClaimsMgtUtil.getAdminUserNameFromTenantId((RealmService)realmService, (int)tenantId), claimsMap, "default");
            log.info((Object)("FirstName: " + accountInfoBean.getFirstname() + " has been updated to the tenant admin " + ClaimsMgtUtil.getAdminUserNameFromTenantId((RealmService)realmService, (int)tenantId) + " of " + tenant.getDomain()));
            TenantInfoBean tenantInfoBean = new TenantInfoBean();
            tenantInfoBean.setTenantId(tenantId);
            tenantInfoBean.setFirstname(accountInfoBean.getFirstname());
            tenantInfoBean.setLastname(accountInfoBean.getLastname());
            Util.alertTenantUpdate(tenantInfoBean);
            return true;
        }
        catch (Exception e) {
            String msg = "Error in updating the firstname: " + accountInfoBean.getFirstname() + " for the tenant admin: " + ClaimsMgtUtil.getAdminUserNameFromTenantId((RealmService)realmService, (int)tenantId);
            log.info((Object)msg);
            throw new Exception(msg, e);
        }
    }

    public AccountInfoBean getFullname() throws Exception {
        String msg;
        Tenant tenant;
        String firstname = "";
        String lastname = "";
        TenantManager tenantManager = Util.getTenantManager();
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        if (registry == null) {
            String msg2 = "Error in retrieving the registry for the login tenant.";
            log.error((Object)msg2);
            throw new Exception(msg2);
        }
        int tenantId = registry.getTenantId();
        try {
            tenant = (Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg3 = "Error in retrieving the tenant information for the tenant id: " + tenantId + ".";
            log.info((Object)msg3, (Throwable)e);
            throw new Exception(msg3, e);
        }
        try {
            firstname = ClaimsMgtUtil.getFirstName((RealmService)Util.getRealmService(), (int)tenantId);
        }
        catch (Exception e) {
            msg = "Error in retrieving the firstname for the admin of the domain " + tenant.getDomain();
            log.info((Object)msg);
        }
        try {
            lastname = ClaimsMgtUtil.getLastName((RealmService)Util.getRealmService(), (int)tenantId);
        }
        catch (Exception e) {
            msg = "Error in retrieving the Lastname for the admin of the domain " + tenant.getDomain();
            log.info((Object)msg);
        }
        AccountInfoBean accountInfoBean = new AccountInfoBean();
        accountInfoBean.setFirstname(firstname);
        accountInfoBean.setLastname(lastname);
        return accountInfoBean;
    }

    public void deactivate() throws Exception {
        TenantManager tenantManager = Util.getTenantManager();
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        if (registry == null) {
            String msg = "Error in retrieving the registry for the login tenant.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        int tenantId = registry.getTenantId();
        try {
            tenantManager.deactivateTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in deactivating the tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        Util.alertTenantDeactivation(tenantId);
    }

    public boolean isDomainValidated() throws Exception {
        Tenant tenant;
        TenantManager tenantManager = Util.getTenantManager();
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        if (registry == null) {
            String msg = "Error in retrieving the registry for the login tenant.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        int tenantId = registry.getTenantId();
        try {
            tenant = (Tenant)tenantManager.getTenant(tenantId);
        }
        catch (UserStoreException e) {
            String msg = "Error in retrieving the tenant information for the tenant id: " + tenantId + ".";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        String domainName = tenant.getDomain();
        TenantMgtUtil.validateDomain((String)domainName);
        String domainValidationPath = "/repository/components/org.wso2.carbon.domain-confirmation-flag/" + tenantId;
        UserRegistry superTenantRegistry = Util.getGovernanceSystemRegistry(-1234);
        if (superTenantRegistry.resourceExists(domainValidationPath)) {
            Resource validationFlagR = superTenantRegistry.get(domainValidationPath);
            return "true".equals(validationFlagR.getProperty(domainName));
        }
        return false;
    }

    public boolean finishedDomainValidation(String validatedDomain, String successKey) throws Exception {
        if (!CommonUtil.validateDomainFromSuccessKey((UserRegistry)Util.getGovernanceSystemRegistry(-1234), (String)validatedDomain, (String)successKey)) {
            String msg = "Domain: " + validatedDomain + " is not validated against successKey: " + successKey + ".";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        UserRegistry registry = (UserRegistry)this.getGovernanceRegistry();
        if (registry == null) {
            String msg = "Error in retrieving the registry for the login tenant.";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        int tenantId = registry.getTenantId();
        String domainValidationPath = "/repository/components/org.wso2.carbon.domain-confirmation-flag/" + tenantId;
        UserRegistry superTenantRegistry = Util.getGovernanceSystemRegistry(-1234);
        Resource validationFlagR = superTenantRegistry.newResource();
        validationFlagR.setProperty(validatedDomain, "true");
        superTenantRegistry.put(domainValidationPath, validationFlagR);
        return true;
    }

    public boolean checkDomainAvailability(String domainName) throws Exception {
        TenantManager tenantManager = Util.getTenantManager();
        int tenantId = tenantManager.getTenantId(domainName);
        return tenantId < 0;
    }

    public boolean isEmailValidated() throws Exception {
        String emailVerificationPath;
        UserRegistry userRegistry = (UserRegistry)this.getGovernanceRegistry();
        if (userRegistry.getTenantId() == -1234) {
            return true;
        }
        String email = this.getContact();
        UserRegistry superTenantSystemRegistry = Util.getGovernanceSystemRegistry(-1234);
        if (!superTenantSystemRegistry.resourceExists(emailVerificationPath = "/repository/components/org.wso2.carbon.email-confirmation-flag/" + userRegistry.getTenantId())) {
            return false;
        }
        Resource resource = superTenantSystemRegistry.get(emailVerificationPath);
        return "true".equals(resource.getProperty(email));
    }
}

