/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.account.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.account.mgt.util.Util;
import org.apache.stratos.common.TenantBillingService;
import org.apache.stratos.common.listeners.TenantMgtListener;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class AccountMgtServiceComponent {
    private static Log log = LogFactory.getLog(AccountMgtServiceComponent.class);
    private static ConfigurationContextService configContextService = null;
    private static TenantBillingService billingService = null;

    protected void activate(ComponentContext context) {
        try {
            Util.loadEmailVerificationConfig();
            log.debug((Object)"******* Stratos account management bundle is activated ******* ");
        }
        catch (Exception e) {
            log.error((Object)"******* Stratos account management bundle failed activating ****", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Stratos account managment bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        Util.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        Util.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the ConfigurationContext");
        }
        configContextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ConfigurationContext");
        }
    }

    protected void setEmailVerificationService(EmailVerifcationSubscriber emailService) {
        Util.setEmailVerificationService(emailService);
    }

    protected void unsetEmailVerificationService(EmailVerifcationSubscriber emailService) {
        Util.setEmailVerificationService(null);
    }

    protected void setTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        Util.addTenantMgtListenerService(tenantMgtListener);
    }

    protected void unsetTenantMgtListenerService(TenantMgtListener tenantMgtListener) {
        Util.removeTenantMgtListenerService(tenantMgtListener);
    }

    protected void setTenantBillingService(TenantBillingService tenantBillingService) {
        billingService = tenantBillingService;
    }

    protected void unsetTenantBillingService(TenantBillingService tenantBilling) {
        this.setTenantBillingService(null);
    }

    public static TenantBillingService getBillingService() {
        return billingService;
    }
}

