/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.utils;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.dto.Policy;
import org.apache.stratos.manager.dto.PolicyDefinition;
import org.jaxen.JaxenException;
import org.w3c.dom.Element;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.SAXException;

public class PolicyHolder {
    private static Log log = LogFactory.getLog(PolicyHolder.class);
    private static final String POLICIES_ELEMENT = "policies";
    private static final String POLICY_ELEMENT = "policy";
    private static final String POLICIES_ELEMENT_XPATH = "/policies/policy";
    private static final String NAME_ATTR = "name";
    private static final String IS_DEFAULT_ATTR = "isDefault";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String MIN_APP_INSTANCES_ELEMENT = "min_app_instances";
    private static final String MAX_APP_INSTANCES_ELEMENT = "max_app_instances";
    private static final String MAX_REQUESTS_PER_SECOND_ELEMENT = "max_requests_per_second";
    private static final String ALARMING_UPPER_RATE_ELEMENT = "alarming_upper_rate";
    private static final String ALARMING_LOWER_RATE_ELEMENT = "alarming_lower_rate";
    private static final String SCALE_DOWN_FACTOR_ELEMENT = "scale_down_factor";
    private static final String ROUNDS_TO_AVERAGE_ELEMENT = "rounds_to_average";
    private Map<String, Policy> policyMap = new HashMap<String, Policy>();
    private Policy defaultPolicy;
    private List<PolicyDefinition> policyDefinitions = new ArrayList<PolicyDefinition>();

    private PolicyHolder(File policiesSchema, File policiesXML) {
        try {
            this.readPolicies(policiesSchema, policiesXML);
        }
        catch (Exception e) {
            log.error((Object)"Error reading policies", (Throwable)e);
        }
    }

    public static PolicyHolder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Policy getPolicy(String policyName) {
        return this.policyMap.get(policyName);
    }

    public Policy getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public List<PolicyDefinition> getPolicyDefinitions() {
        return this.policyDefinitions;
    }

    private void readPolicies(File policiesSchema, File policiesXML) throws XMLStreamException, JaxenException, SAXException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Policies schema: " + policiesSchema.getPath()));
            log.debug((Object)("Loading policies from file: " + policiesXML.getPath()));
        }
        if (!policiesXML.exists()) {
            throw new IllegalStateException("Policies file cannot be found : " + policiesXML.getPath());
        }
        OMElement documentElement = new StAXOMBuilder(policiesXML.getPath()).getDocumentElement();
        this.validate(documentElement, policiesSchema);
        String xpath = POLICIES_ELEMENT_XPATH;
        AXIOMXPath axiomXpath = new AXIOMXPath(xpath);
        List policyNodes = axiomXpath.selectNodes((Object)documentElement);
        if (policyNodes == null || policyNodes.isEmpty()) {
            log.warn((Object)("No policies found in the file : " + policiesXML.getPath()));
            return;
        }
        for (OMNode policyNode : policyNodes) {
            if (policyNode.getType() != 1) continue;
            OMElement policyElement = (OMElement)policyNode;
            try {
                this.readPolicy(policyElement);
            }
            catch (Exception e) {
                log.error((Object)"Error reading policy", (Throwable)e);
            }
        }
    }

    private void readPolicy(OMElement policyElement) {
        OMElement element;
        String name = policyElement.getAttributeValue(new QName(NAME_ATTR));
        boolean isDefault = Boolean.valueOf(policyElement.getAttributeValue(new QName(IS_DEFAULT_ATTR)));
        Policy policy = new Policy();
        policy.setName(name);
        policy.setDefaultPolicy(isDefault);
        Iterator it = policyElement.getChildrenWithName(new QName(DESCRIPTION_ELEMENT));
        if (it.hasNext()) {
            element = (OMElement)it.next();
            policy.setDescription(element.getText());
        }
        if ((it = policyElement.getChildrenWithName(new QName(MIN_APP_INSTANCES_ELEMENT))).hasNext()) {
            element = (OMElement)it.next();
            policy.setMinAppInstances(Integer.parseInt(element.getText()));
        }
        if ((it = policyElement.getChildrenWithName(new QName(MAX_APP_INSTANCES_ELEMENT))).hasNext()) {
            element = (OMElement)it.next();
            policy.setMaxAppInstances(Integer.parseInt(element.getText()));
        }
        if ((it = policyElement.getChildrenWithName(new QName(MAX_REQUESTS_PER_SECOND_ELEMENT))).hasNext()) {
            element = (OMElement)it.next();
            policy.setMaxRequestsPerSecond(Integer.parseInt(element.getText()));
        }
        if ((it = policyElement.getChildrenWithName(new QName(ROUNDS_TO_AVERAGE_ELEMENT))).hasNext()) {
            element = (OMElement)it.next();
            policy.setRoundsToAverage(Integer.parseInt(element.getText()));
        }
        if ((it = policyElement.getChildrenWithName(new QName(ALARMING_UPPER_RATE_ELEMENT))).hasNext()) {
            element = (OMElement)it.next();
            policy.setAlarmingUpperRate(new BigDecimal(element.getText()));
        }
        if ((it = policyElement.getChildrenWithName(new QName(ALARMING_LOWER_RATE_ELEMENT))).hasNext()) {
            element = (OMElement)it.next();
            policy.setAlarmingLowerRate(new BigDecimal(element.getText()));
        }
        if ((it = policyElement.getChildrenWithName(new QName(SCALE_DOWN_FACTOR_ELEMENT))).hasNext()) {
            element = (OMElement)it.next();
            policy.setScaleDownFactor(new BigDecimal(element.getText()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Policy: " + new Gson().toJson((Object)policy)));
        }
        this.policyMap.put(policy.getName(), policy);
        PolicyDefinition policyDefinition = new PolicyDefinition();
        policyDefinition.setName(policy.getName());
        policyDefinition.setDescription(policy.getDescription());
        policyDefinition.setDefaultPolicy(policy.isDefaultPolicy());
        this.policyDefinitions.add(policyDefinition);
        if (this.defaultPolicy == null && policy.isDefaultPolicy()) {
            this.defaultPolicy = policy;
        }
    }

    public void validate(OMElement omElement, File schemaFile) throws SAXException, IOException {
        Element sourceElement = omElement instanceof ElementImpl ? (Element)omElement : this.getDOMElement(omElement);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource source = new StreamSource(schemaFile);
        Schema schema = factory.newSchema(source);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(sourceElement));
    }

    private Element getDOMElement(OMElement omElement) {
        XMLStreamReader llomReader = omElement.getXMLStreamReader();
        OMFactory doomFactory = DOOMAbstractFactory.getOMFactory();
        StAXOMBuilder doomBuilder = new StAXOMBuilder(doomFactory, llomReader);
        OMElement newElem = doomBuilder.getDocumentElement();
        return newElem instanceof Element ? (Element)newElem : null;
    }

    private static class SingletonHolder {
        private static final PolicyHolder INSTANCE = new PolicyHolder(new File(CarbonUtils.getCarbonConfigDirPath() + File.separator + "etc" + File.separator, "policies.xsd"), new File(CarbonUtils.getCarbonConfigDirPath(), "policies.xml"));

        private SingletonHolder() {
        }
    }
}

