/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.topology.receiver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.topology.model.TopologyClusterInformationModel;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.topology.ClusterCreatedEvent;
import org.apache.stratos.messaging.event.topology.ClusterRemovedEvent;
import org.apache.stratos.messaging.event.topology.InstanceSpawnedEvent;
import org.apache.stratos.messaging.event.topology.MemberActivatedEvent;
import org.apache.stratos.messaging.event.topology.MemberStartedEvent;
import org.apache.stratos.messaging.event.topology.MemberSuspendedEvent;
import org.apache.stratos.messaging.event.topology.MemberTerminatedEvent;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.listener.topology.ClusterCreatedEventListener;
import org.apache.stratos.messaging.listener.topology.ClusterRemovedEventListener;
import org.apache.stratos.messaging.listener.topology.CompleteTopologyEventListener;
import org.apache.stratos.messaging.listener.topology.InstanceSpawnedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberActivatedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberStartedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberSuspendedEventListener;
import org.apache.stratos.messaging.listener.topology.MemberTerminatedEventListener;
import org.apache.stratos.messaging.message.receiver.topology.TopologyEventReceiver;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class StratosManagerTopologyEventReceiver
implements Runnable {
    private static final Log log = LogFactory.getLog(StratosManagerTopologyEventReceiver.class);
    private TopologyEventReceiver topologyEventReceiver = new TopologyEventReceiver();
    private boolean terminated = false;

    public StratosManagerTopologyEventReceiver() {
        this.addEventListeners();
    }

    private void addEventListeners() {
        this.topologyEventReceiver.addEventListener((EventListener)new CompleteTopologyEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                if (TopologyClusterInformationModel.getInstance().isInitialized()) {
                    return;
                }
                log.info((Object)("[CompleteTopologyEventListener] Received: " + event.getClass()));
                try {
                    TopologyManager.acquireReadLock();
                    for (Service service : TopologyManager.getTopology().getServices()) {
                        for (Cluster cluster : service.getClusters()) {
                            TopologyClusterInformationModel.getInstance().addCluster(cluster);
                        }
                    }
                    TopologyClusterInformationModel.getInstance().setInitialized(true);
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterCreatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                log.info((Object)("[ClusterCreatedEventListener] Received: " + event.getClass()));
                ClusterCreatedEvent clustercreatedEvent = (ClusterCreatedEvent)event;
                String serviceType = clustercreatedEvent.getServiceName();
                TopologyManager.acquireReadLock();
                try {
                    Cluster cluster = TopologyManager.getTopology().getService(serviceType).getCluster(clustercreatedEvent.getClusterId());
                    TopologyClusterInformationModel.getInstance().addCluster(cluster);
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new ClusterRemovedEventListener(){

            protected void onEvent(Event event) {
                log.info((Object)("[ClusterRemovedEventListener] Received: " + event.getClass()));
                ClusterRemovedEvent clusterRemovedEvent = (ClusterRemovedEvent)event;
                TopologyClusterInformationModel.getInstance().removeCluster(clusterRemovedEvent.getClusterId());
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new InstanceSpawnedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                log.info((Object)("[InstanceSpawnedEventListener] Received: " + event.getClass()));
                InstanceSpawnedEvent instanceSpawnedEvent = (InstanceSpawnedEvent)event;
                String clusterDomain = instanceSpawnedEvent.getClusterId();
                String serviceType = instanceSpawnedEvent.getServiceName();
                TopologyManager.acquireReadLock();
                try {
                    Cluster cluster = TopologyManager.getTopology().getService(serviceType).getCluster(clusterDomain);
                    TopologyClusterInformationModel.getInstance().addCluster(cluster);
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberStartedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                log.info((Object)("[MemberStartedEventListener] Received: " + event.getClass()));
                MemberStartedEvent memberStartedEvent = (MemberStartedEvent)event;
                String clusterDomain = memberStartedEvent.getClusterId();
                String serviceType = memberStartedEvent.getServiceName();
                TopologyManager.acquireReadLock();
                try {
                    Cluster cluster = TopologyManager.getTopology().getService(serviceType).getCluster(clusterDomain);
                    TopologyClusterInformationModel.getInstance().addCluster(cluster);
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberActivatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                log.info((Object)("[MemberActivatedEventListener] Received: " + event.getClass()));
                MemberActivatedEvent memberActivatedEvent = (MemberActivatedEvent)event;
                String clusterDomain = memberActivatedEvent.getClusterId();
                String serviceType = memberActivatedEvent.getServiceName();
                TopologyManager.acquireReadLock();
                try {
                    Cluster cluster = TopologyManager.getTopology().getService(serviceType).getCluster(clusterDomain);
                    TopologyClusterInformationModel.getInstance().addCluster(cluster);
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberSuspendedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                log.info((Object)("[MemberSuspendedEventListener] Received: " + event.getClass()));
                MemberSuspendedEvent memberSuspendedEvent = (MemberSuspendedEvent)event;
                String clusterDomain = memberSuspendedEvent.getClusterId();
                String serviceType = memberSuspendedEvent.getServiceName();
                TopologyManager.acquireReadLock();
                try {
                    Cluster cluster = TopologyManager.getTopology().getService(serviceType).getCluster(clusterDomain);
                    TopologyClusterInformationModel.getInstance().addCluster(cluster);
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
        this.topologyEventReceiver.addEventListener((EventListener)new MemberTerminatedEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onEvent(Event event) {
                log.info((Object)("[MemberTerminatedEventListener] Received: " + event.getClass()));
                MemberTerminatedEvent memberTerminatedEvent = (MemberTerminatedEvent)event;
                String clusterDomain = memberTerminatedEvent.getClusterId();
                String serviceType = memberTerminatedEvent.getServiceName();
                TopologyManager.acquireReadLock();
                try {
                    Cluster cluster = TopologyManager.getTopology().getService(serviceType).getCluster(clusterDomain);
                    if (cluster.memberExists(memberTerminatedEvent.getMemberId())) {
                        TopologyManager.releaseReadLock();
                        TopologyManager.acquireWriteLock();
                        try {
                            if (cluster.memberExists(memberTerminatedEvent.getMemberId())) {
                                Member terminatedMember = cluster.getMember(memberTerminatedEvent.getMemberId());
                                cluster.removeMember(terminatedMember);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Removed the terminated member with id " + memberTerminatedEvent.getMemberId() + " from the cluster"));
                                }
                            }
                            TopologyManager.acquireReadLock();
                        }
                        finally {
                            TopologyManager.releaseWriteLock();
                        }
                    }
                    TopologyClusterInformationModel.getInstance().addCluster(cluster);
                }
                finally {
                    TopologyManager.releaseReadLock();
                }
            }
        });
    }

    @Override
    public void run() {
        Thread thread = new Thread((Runnable)this.topologyEventReceiver);
        thread.start();
        log.info((Object)"Stratos Manager topology receiver thread started");
        while (!this.terminated) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)"Stratos Manager topology receiver thread terminated");
    }

    public void terminate() {
        this.topologyEventReceiver.terminate();
        this.terminated = true;
    }
}

