/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription.tenancy;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.manager.dao.Cluster;
import org.apache.stratos.manager.deploy.service.Service;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.AlreadySubscribedException;
import org.apache.stratos.manager.exception.NotSubscribedException;
import org.apache.stratos.manager.exception.PersistenceManagerException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.payload.PayloadData;
import org.apache.stratos.manager.publisher.InstanceNotificationPublisher;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscriber.Subscriber;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionTenancyBehaviour;

public class SubscriptionMultiTenantBehaviour
extends SubscriptionTenancyBehaviour {
    private static Log log = LogFactory.getLog(SubscriptionMultiTenantBehaviour.class);

    @Override
    public PayloadData create(String alias, Cluster cluster, Subscriber subscriber, Repository repository, CartridgeInfo cartridgeInfo, String subscriptionKey, Map<String, String> customPayloadEntries) throws ADCException, AlreadySubscribedException {
        Service deployedService;
        boolean allowMultipleSubscription = Boolean.valueOf(System.getProperty("feature.multitenant.multiplesubscription.enabled"));
        if (!allowMultipleSubscription) {
            boolean subscribed;
            try {
                subscribed = SubscriptionMultiTenantBehaviour.hasAlreadySubscribed(subscriber.getTenantId(), cartridgeInfo.getType());
            }
            catch (Exception e) {
                String msg = "Error checking whether the cartridge type " + cartridgeInfo.getType() + " is already subscribed";
                log.error((Object)msg, (Throwable)e);
                throw new ADCException(msg, e);
            }
            if (subscribed) {
                String msg = "Already subscribed to " + cartridgeInfo.getType() + ". This multi-tenant cartridge will not be available to createSubscription";
                if (log.isDebugEnabled()) {
                    log.debug((Object)msg);
                }
                throw new AlreadySubscribedException(msg, cartridgeInfo.getType());
            }
        }
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        try {
            deployedService = dataInsertionAndRetrievalManager.getService(cartridgeInfo.getType());
        }
        catch (PersistenceManagerException e) {
            String errorMsg = "Error in checking if Service is available is PersistenceManager";
            log.error((Object)errorMsg, (Throwable)e);
            throw new ADCException(errorMsg, e);
        }
        if (deployedService == null) {
            String errorMsg = "There is no deployed Service for type " + cartridgeInfo.getType();
            log.error((Object)errorMsg);
            throw new ADCException(errorMsg);
        }
        cluster.setClusterDomain(deployedService.getClusterId());
        cluster.setHostName(deployedService.getHostName());
        if (repository != null) {
            log.info((Object)" Multitenant --> Publishing Artifact update event -- ");
            log.info((Object)(" Values :  cluster id - " + cluster.getClusterDomain() + "  tenant - " + subscriber.getTenantId()));
            InstanceNotificationPublisher publisher = new InstanceNotificationPublisher();
            publisher.sendArtifactUpdateEvent(repository, cluster.getClusterDomain(), String.valueOf(subscriber.getTenantId()));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No repository found for subscription with alias: " + alias + ", type: " + cartridgeInfo.getType() + ". Not sending the Artifact Updated event"));
        }
        return null;
    }

    @Override
    public void register(CartridgeInfo cartridgeInfo, Cluster cluster, PayloadData payloadData, String autoscalePolicyName, String deploymentPolicyName, Properties properties) throws ADCException, UnregisteredCartridgeException {
    }

    @Override
    public void remove(String clusterId, String alias) throws ADCException, NotSubscribedException {
        log.info((Object)("Cartridge Subscription with alias " + alias + ", and cluster id " + clusterId + " is a multi-tenant cartridge and therefore will not terminate all instances and " + "unregister services"));
    }

    private static boolean hasAlreadySubscribed(int tenantId, String cartridgeType) {
        DataInsertionAndRetrievalManager dataInsertionAndRetrievalManager = new DataInsertionAndRetrievalManager();
        return dataInsertionAndRetrievalManager.getCartridgeSubscriptions(tenantId, cartridgeType) != null && !dataInsertionAndRetrievalManager.getCartridgeSubscriptions(tenantId, cartridgeType).isEmpty();
    }
}

