/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription;

import java.util.HashMap;
import java.util.Map;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.manager.dao.CartridgeSubscriptionInfo;
import org.apache.stratos.manager.dao.DataCartridge;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionTenancyBehaviour;
import org.apache.stratos.manager.utils.ApplicationManagementUtil;

public class DataCartridgeSubscription
extends CartridgeSubscription {
    private String host;
    private String username;
    private String password;

    public DataCartridgeSubscription(CartridgeInfo cartridgeInfo, SubscriptionTenancyBehaviour subscriptionTenancyBehaviour) {
        super(cartridgeInfo, subscriptionTenancyBehaviour);
        this.setDBHost("localhost");
        this.setDBUsername("root");
        this.setDBPassword(ApplicationManagementUtil.generatePassword());
    }

    @Override
    public CartridgeSubscriptionInfo registerSubscription(Properties properties) throws ADCException, UnregisteredCartridgeException {
        this.getSubscriptionTenancyBehaviour().register(this.getCartridgeInfo(), this.getCluster(), this.getPayloadData(), this.getAutoscalingPolicyName(), this.getDeploymentPolicyName(), properties);
        DataCartridge dataCartridge = new DataCartridge();
        dataCartridge.setUserName(this.getDBUsername());
        dataCartridge.setPassword(this.getDBPassword());
        dataCartridge.setDataCartridgeType(this.getType());
        return ApplicationManagementUtil.createCartridgeSubscription(this.getCartridgeInfo(), this.getAutoscalingPolicyName(), this.getType(), this.getAlias(), this.getSubscriber().getTenantId(), this.getSubscriber().getTenantDomain(), this.getRepository(), this.getCluster().getHostName(), this.getCluster().getClusterDomain(), this.getCluster().getClusterSubDomain(), this.getCluster().getMgtClusterDomain(), this.getCluster().getMgtClusterSubDomain(), dataCartridge, "PENDING", this.getSubscriptionKey());
    }

    @Override
    public Repository manageRepository(String repoURL, String repoUserName, String repoUserPassword, boolean privateRepo) {
        return null;
    }

    @Override
    public Map<String, String> getCustomPayloadEntries() {
        HashMap<String, String> payloadEntriesMap = new HashMap<String, String>();
        payloadEntriesMap.put("DB_HOST", this.host);
        payloadEntriesMap.put("DB_USER", this.username);
        payloadEntriesMap.put("MYSQL_PASSWORD", this.password);
        return payloadEntriesMap;
    }

    public String getDBHost() {
        return this.host;
    }

    public void setDBHost(String host) {
        this.host = host;
    }

    public String getDBUsername() {
        return this.username;
    }

    public void setDBUsername(String username) {
        this.username = username;
    }

    public String getDBPassword() {
        return this.password;
    }

    public void setDBPassword(String password) {
        this.password = password;
    }
}

