/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.retriever;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.deploy.service.Service;
import org.apache.stratos.manager.exception.PersistenceManagerException;
import org.apache.stratos.manager.lookup.LookupDataHolder;
import org.apache.stratos.manager.persistence.PersistenceManager;
import org.apache.stratos.manager.persistence.RegistryBasedPersistenceManager;
import org.apache.stratos.manager.subscription.CartridgeSubscription;

public class DataInsertionAndRetrievalManager {
    private static final Log log = LogFactory.getLog(DataInsertionAndRetrievalManager.class);
    private static PersistenceManager persistenceManager = new RegistryBasedPersistenceManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheAndPersistSubcription(CartridgeSubscription cartridgeSubscription) throws PersistenceManagerException {
        LookupDataHolder.getInstance().acquireWriteLock();
        try {
            LookupDataHolder.getInstance().putSubscription(cartridgeSubscription);
            try {
                persistenceManager.persistCartridgeSubscription(cartridgeSubscription);
            }
            catch (PersistenceManagerException e) {
                String errorMsg = "Error in persisting CartridgeSubscription in Persistence Manager";
                log.error((Object)errorMsg, (Throwable)e);
                LookupDataHolder.getInstance().removeSubscription(cartridgeSubscription.getSubscriber().getTenantId(), cartridgeSubscription.getType(), cartridgeSubscription.getAlias(), cartridgeSubscription.getClusterDomain(), cartridgeSubscription.getRepository() != null ? cartridgeSubscription.getRepository().getUrl() : null);
                throw e;
            }
        }
        finally {
            LookupDataHolder.getInstance().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(int tenantId, String subscriptionAlias) throws PersistenceManagerException {
        CartridgeSubscription cartridgeSubscription = this.getCartridgeSubscription(tenantId, subscriptionAlias);
        if (cartridgeSubscription == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No CartridgeSubscription found for tenant " + tenantId + ", subscription alias " + subscriptionAlias));
            }
            return;
        }
        String cartridgeType = cartridgeSubscription.getType();
        String clusterId = cartridgeSubscription.getClusterDomain();
        LookupDataHolder.getInstance().acquireWriteLock();
        try {
            try {
                persistenceManager.removeCartridgeSubscription(tenantId, cartridgeType, subscriptionAlias);
            }
            catch (PersistenceManagerException e) {
                String errorMsg = "Error in removing CartridgeSubscription from Persistence Manager";
                log.error((Object)errorMsg, (Throwable)e);
                throw e;
            }
            LookupDataHolder.getInstance().removeSubscription(tenantId, cartridgeType, subscriptionAlias, clusterId, cartridgeSubscription.getRepository() != null ? cartridgeSubscription.getRepository().getUrl() : null);
        }
        finally {
            LookupDataHolder.getInstance().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cachePersistedSubscriptions() throws PersistenceManagerException {
        LookupDataHolder.getInstance().acquireWriteLock();
        try {
            Collection<CartridgeSubscription> cartridgeSubscriptions;
            try {
                cartridgeSubscriptions = persistenceManager.getCartridgeSubscriptions();
            }
            catch (PersistenceManagerException e) {
                String errorMsg = "Error in retrieving CartridgeSubscriptions from Persistence Manager";
                log.error((Object)errorMsg, (Throwable)e);
                throw e;
            }
            if (cartridgeSubscriptions == null || cartridgeSubscriptions.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No CartridgeSubscriptions found to add to the cache");
                }
                return;
            }
            this.cacheSubscriptions(cartridgeSubscriptions);
        }
        finally {
            LookupDataHolder.getInstance().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cachePersistedSubscriptions(int tenantId) throws PersistenceManagerException {
        LookupDataHolder.getInstance().acquireWriteLock();
        try {
            Collection<CartridgeSubscription> cartridgeSubscriptions;
            try {
                cartridgeSubscriptions = persistenceManager.getCartridgeSubscriptions(tenantId);
            }
            catch (PersistenceManagerException e) {
                String errorMsg = "Error in retrieving CartridgeSubscriptions from Persistence Manager";
                log.error((Object)errorMsg, (Throwable)e);
                throw e;
            }
            if (cartridgeSubscriptions == null || cartridgeSubscriptions.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No CartridgeSubscriptions found to add to the cache");
                }
                return;
            }
            this.cacheSubscriptions(cartridgeSubscriptions);
        }
        finally {
            LookupDataHolder.getInstance().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheSubscriptionsWithoutPersisting(Collection<CartridgeSubscription> cartridgeSubscriptions) {
        LookupDataHolder.getInstance().acquireWriteLock();
        try {
            this.cacheSubscriptions(cartridgeSubscriptions);
        }
        finally {
            LookupDataHolder.getInstance().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriptionFromCache(int tenantId, String subscriptionAlias) {
        LookupDataHolder.getInstance().acquireWriteLock();
        CartridgeSubscription cartridgeSubscription = this.getCartridgeSubscription(tenantId, subscriptionAlias);
        if (cartridgeSubscription == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No CartridgeSubscription found for tenant " + tenantId + ", subscription alias " + subscriptionAlias));
            }
            return;
        }
        String cartridgeType = cartridgeSubscription.getType();
        String clusterId = cartridgeSubscription.getClusterDomain();
        try {
            LookupDataHolder.getInstance().removeSubscription(tenantId, cartridgeType, subscriptionAlias, clusterId, cartridgeSubscription.getRepository() != null ? cartridgeSubscription.getRepository().getUrl() : null);
        }
        finally {
            LookupDataHolder.getInstance().releaseWriteLock();
        }
    }

    private void cacheSubscriptions(Collection<CartridgeSubscription> cartridgeSubscriptions) {
        for (CartridgeSubscription cartridgeSubscription : cartridgeSubscriptions) {
            LookupDataHolder.getInstance().putSubscription(cartridgeSubscription);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Updated the in memory cache with the CartridgeSubscription: " + cartridgeSubscription.toString()));
        }
    }

    public void persistService(Service service) throws PersistenceManagerException {
        persistenceManager.persistService(service);
    }

    public Collection<Service> getServices() throws PersistenceManagerException {
        return persistenceManager.getServices();
    }

    public Service getService(String cartridgeType) throws PersistenceManagerException {
        return persistenceManager.getService(cartridgeType);
    }

    public void removeService(String cartridgeType) throws PersistenceManagerException {
        persistenceManager.removeService(cartridgeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CartridgeSubscription> getCartridgeSubscriptions(String cartridgeType) {
        LookupDataHolder.getInstance().acquireReadLock();
        try {
            Collection<CartridgeSubscription> collection = LookupDataHolder.getInstance().getSubscriptions(cartridgeType);
            return collection;
        }
        finally {
            LookupDataHolder.getInstance().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CartridgeSubscription getCartridgeSubscription(int tenantId, String subscriptionAlias) {
        LookupDataHolder.getInstance().acquireReadLock();
        try {
            CartridgeSubscription cartridgeSubscription = LookupDataHolder.getInstance().getSubscriptionForAlias(tenantId, subscriptionAlias);
            return cartridgeSubscription;
        }
        finally {
            LookupDataHolder.getInstance().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CartridgeSubscription> getCartridgeSubscriptionForCluster(String clusterId) {
        LookupDataHolder.getInstance().acquireReadLock();
        try {
            Set<CartridgeSubscription> set = LookupDataHolder.getInstance().getSubscription(clusterId);
            return set;
        }
        finally {
            LookupDataHolder.getInstance().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CartridgeSubscription> getCartridgeSubscriptionForRepository(String repoUrl) {
        LookupDataHolder.getInstance().acquireReadLock();
        try {
            Set<CartridgeSubscription> set = LookupDataHolder.getInstance().getSubscriptionsForRepoUrl(repoUrl);
            return set;
        }
        finally {
            LookupDataHolder.getInstance().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CartridgeSubscription> getCartridgeSubscriptions(int tenantId) {
        LookupDataHolder.getInstance().acquireReadLock();
        try {
            Collection<CartridgeSubscription> collection = LookupDataHolder.getInstance().getSubscriptions(tenantId);
            return collection;
        }
        finally {
            LookupDataHolder.getInstance().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CartridgeSubscription> getCartridgeSubscriptions(int tenantId, String cartridgeType) {
        LookupDataHolder.getInstance().acquireReadLock();
        try {
            Collection<CartridgeSubscription> collection = LookupDataHolder.getInstance().getSubscriptionForType(tenantId, cartridgeType);
            return collection;
        }
        finally {
            LookupDataHolder.getInstance().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CartridgeSubscription getCartridgeSubscriptionForAlias(String subscriptionAlias) {
        LookupDataHolder.getInstance().acquireReadLock();
        try {
            CartridgeSubscription cartridgeSubscription = LookupDataHolder.getInstance().getSubscriptionForAlias(subscriptionAlias);
            return cartridgeSubscription;
        }
        finally {
            LookupDataHolder.getInstance().releaseReadLock();
        }
    }
}

