/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.publisher;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.publisher.TenantSynzhronizerTask;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.service.TaskService;

public class TenantSynchronizerTaskScheduler {
    private static final Log log = LogFactory.getLog(TenantSynzhronizerTask.class);
    private static final String TENANT_SYNC_TASK_TYPE = "TENANT_SYNC_TASK_TYPE";
    private static final String TENANT_SYNC_TASK_NAME = "TENANT_SYNC_TASK";
    private static final String DEFAULT_CRON = "1 * * * * ? *";

    public static void schedule(TaskService taskService) {
        TaskManager taskManager = null;
        try {
            if (!taskService.getRegisteredTaskTypes().contains(TENANT_SYNC_TASK_TYPE)) {
                taskService.registerTaskType(TENANT_SYNC_TASK_TYPE);
                taskManager = taskService.getTaskManager(TENANT_SYNC_TASK_TYPE);
                TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo(DEFAULT_CRON);
                TaskInfo taskInfo = new TaskInfo(TENANT_SYNC_TASK_NAME, TenantSynzhronizerTask.class.getName(), new HashMap(), triggerInfo);
                taskManager.registerTask(taskInfo);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Tenant synchronization task scheduled: %s", TENANT_SYNC_TASK_NAME));
                }
            }
        }
        catch (Exception e) {
            block7: {
                if (taskManager != null) {
                    try {
                        taskManager.deleteTask(TENANT_SYNC_TASK_NAME);
                    }
                    catch (TaskException te) {
                        if (!log.isErrorEnabled()) break block7;
                        log.error((Object)te);
                    }
                }
            }
            throw new RuntimeException(String.format("Could not schedule tenant synchronization task: %s", TENANT_SYNC_TASK_NAME), e);
        }
    }
}

