/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.publisher;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.exception.ADCException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.databridge.agent.thrift.AsyncDataPublisher;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.utils.CarbonUtils;

public class CartridgeSubscriptionDataPublisher {
    private static final Log log = LogFactory.getLog(CartridgeSubscriptionDataPublisher.class);
    private static AsyncDataPublisher dataPublisher;
    private static StreamDefinition streamDefinition;
    private static final String stratosManagerEventStreamVersion = "1.0.0";

    public static void publish(int tenantID, String adminUser, String cartridgeAlias, String cartridgeType, String repositoryUrl, boolean isMultiTenant, String autoScalingPolicy, String deploymentPolicy, String clusterID, String hostName, String mappedDomain, String action) throws ADCException {
        block6: {
            if (!Boolean.parseBoolean(System.getProperty("bam.publisher.enabled"))) {
                return;
            }
            log.debug((Object)"CartridgeSubscriptionDataPublisher cycle started.");
            if (dataPublisher == null) {
                CartridgeSubscriptionDataPublisher.createDataPublisher();
                if (dataPublisher == null) {
                    log.error((Object)"Data Publisher cannot be created or found.");
                    return;
                }
            }
            ArrayList<String> payload = new ArrayList<String>();
            payload.add(String.valueOf(tenantID));
            payload.add(adminUser);
            payload.add(cartridgeAlias);
            payload.add(cartridgeType);
            payload.add(repositoryUrl);
            payload.add(String.valueOf(isMultiTenant));
            payload.add(autoScalingPolicy);
            payload.add(deploymentPolicy);
            payload.add(String.valueOf(clusterID));
            payload.add(hostName);
            payload.add(mappedDomain);
            payload.add(action);
            Event event = new Event();
            event.setPayloadData(payload.toArray());
            event.setArbitraryDataMap(new HashMap());
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Publishing BAM event: [stream] %s [version] %s", streamDefinition.getName(), streamDefinition.getVersion()));
                }
                dataPublisher.publish(streamDefinition.getName(), streamDefinition.getVersion(), event);
            }
            catch (AgentException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)String.format("Could not publish BAM event: [stream] %s [version] %s", streamDefinition.getName(), streamDefinition.getVersion()), (Throwable)e);
            }
        }
    }

    private static StreamDefinition initializeStream() throws Exception {
        streamDefinition = new StreamDefinition("org_apache_stratos_manager", stratosManagerEventStreamVersion);
        streamDefinition.setNickName("stratos.manager");
        streamDefinition.setDescription("Tenant Subscription Data");
        ArrayList<Attribute> payloadData = new ArrayList<Attribute>();
        payloadData.add(new Attribute("tenantID", AttributeType.STRING));
        payloadData.add(new Attribute("adminUser", AttributeType.STRING));
        payloadData.add(new Attribute("cartridgeAlias", AttributeType.STRING));
        payloadData.add(new Attribute("cartridgeType", AttributeType.STRING));
        payloadData.add(new Attribute("repositoryUrl", AttributeType.STRING));
        payloadData.add(new Attribute("isMultiTenant", AttributeType.STRING));
        payloadData.add(new Attribute("autoScalePolicy", AttributeType.STRING));
        payloadData.add(new Attribute("deploymentPolicy", AttributeType.STRING));
        payloadData.add(new Attribute("clusterId", AttributeType.STRING));
        payloadData.add(new Attribute("hostname", AttributeType.STRING));
        payloadData.add(new Attribute("mappedDomain", AttributeType.STRING));
        payloadData.add(new Attribute("action", AttributeType.STRING));
        streamDefinition.setPayloadData(payloadData);
        return streamDefinition;
    }

    private static void createDataPublisher() throws ADCException {
        ServerConfiguration serverConfig = CarbonUtils.getServerConfiguration();
        String trustStorePath = serverConfig.getFirstProperty("Security.TrustStore.Location");
        String trustStorePassword = serverConfig.getFirstProperty("Security.TrustStore.Password");
        String bamServerUrl = serverConfig.getFirstProperty("BamServerURL");
        String adminUsername = System.getProperty("bam.admin.username");
        String adminPassword = System.getProperty("bam.admin.password");
        System.setProperty("javax.net.ssl.trustStore", trustStorePath);
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        try {
            dataPublisher = new AsyncDataPublisher("tcp://" + bamServerUrl + "", adminUsername, adminPassword);
            CartridgeSubscriptionDataPublisher.initializeStream();
            dataPublisher.addStreamDefinition(streamDefinition);
        }
        catch (Exception e) {
            String msg = "Unable to create a data publisher to " + bamServerUrl;
            log.error((Object)msg, (Throwable)e);
            throw new ADCException(msg, e);
        }
    }
}

