/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.lookup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.subscription.CartridgeSubscription;

public class RepoUrlToCartridgeSubscriptions {
    private static final Log log = LogFactory.getLog(RepoUrlToCartridgeSubscriptions.class);
    private Map<String, Set<CartridgeSubscription>> repoUrlToCartridgeSubscriptions = new HashMap<String, Set<CartridgeSubscription>>();

    public void addSubscription(CartridgeSubscription cartridgeSubscription) {
        if (cartridgeSubscription.getRepository() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No repository URL found for Cartridge Subscription for alias " + cartridgeSubscription.getAlias() + ", not adding to [Repo URL -> Set<CartridgeSubscription>] map"));
            }
            return;
        }
        String repoUrl = cartridgeSubscription.getRepository().getUrl();
        if (this.repoUrlToCartridgeSubscriptions.containsKey(repoUrl)) {
            Set<CartridgeSubscription> existingSubscriptions = this.repoUrlToCartridgeSubscriptions.get(repoUrl);
            if (existingSubscriptions.remove(cartridgeSubscription) && log.isDebugEnabled()) {
                log.debug((Object)("Removed the existing Cartridge Subscription for repo URL " + repoUrl + " in [Repo URL -> Set<CartridgeSubscription>] map"));
            }
            existingSubscriptions.add(cartridgeSubscription);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Cartridge Subscription for repo URL " + repoUrl + " in [Repo URL -> Set<CartridgeSubscription>] map"));
            }
        } else {
            HashSet<CartridgeSubscription> subscriptions = new HashSet<CartridgeSubscription>();
            subscriptions.add(cartridgeSubscription);
            this.repoUrlToCartridgeSubscriptions.put(repoUrl, subscriptions);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added Cartridge Subscription for repo URL " + repoUrl + " in [Repo URL -> Set<CartridgeSubscription>] map"));
            }
        }
    }

    public Set<CartridgeSubscription> getSubscriptions(String repoUrl) {
        return this.repoUrlToCartridgeSubscriptions.get(repoUrl);
    }

    public void removeSubscription(String repoUrl, String subscriptionAlias) {
        if (repoUrl == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Repository URL is null for subscription alias " + subscriptionAlias));
            }
            return;
        }
        Set<CartridgeSubscription> existingSubscriptions = this.repoUrlToCartridgeSubscriptions.get(repoUrl);
        if (existingSubscriptions != null && !existingSubscriptions.isEmpty()) {
            Iterator<CartridgeSubscription> iterator = existingSubscriptions.iterator();
            while (iterator.hasNext()) {
                CartridgeSubscription cartridgeSubscription = iterator.next();
                if (!cartridgeSubscription.getAlias().equals(subscriptionAlias)) continue;
                iterator.remove();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Deleted the subscription for repo URL " + repoUrl + " from [Repo URL -> Set<CartridgeSubscription>] map"));
                break;
            }
        }
        if (existingSubscriptions == null || existingSubscriptions.isEmpty()) {
            this.repoUrlToCartridgeSubscriptions.remove(repoUrl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted the subscriptions set for repo URL " + repoUrl + " from [Repo URL -> Set<CartridgeSubscription>] map"));
            }
        }
    }
}

