/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.listener;

import java.util.Set;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.publisher.InstanceNotificationPublisher;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.messaging.event.instance.status.InstanceStartedEvent;
import org.apache.stratos.messaging.util.Util;

public class InstanceStatusListener
implements MessageListener {
    private static final Log log = LogFactory.getLog(InstanceStatusListener.class);

    public void onMessage(Message message) {
        block10: {
            TextMessage receivedMessage = (TextMessage)message;
            if (log.isInfoEnabled()) {
                log.info((Object)"Instance status message received");
            }
            try {
                String type = message.getStringProperty("event-class-name");
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Event class name: %s ", type));
                }
                if (InstanceStartedEvent.class.getName().equals(type)) {
                    Set<CartridgeSubscription> cartridgeSubscriptions;
                    String json = receivedMessage.getText();
                    InstanceStartedEvent event = (InstanceStartedEvent)Util.jsonToObject((String)json, InstanceStartedEvent.class);
                    String clusterId = event.getClusterId();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Cluster id: " + clusterId));
                    }
                    if ((cartridgeSubscriptions = new DataInsertionAndRetrievalManager().getCartridgeSubscriptionForCluster(clusterId)) == null || cartridgeSubscriptions.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("No subscription information found for cluster id " + clusterId));
                        }
                        return;
                    }
                    for (CartridgeSubscription cartridgeSubscription : cartridgeSubscriptions) {
                        if (cartridgeSubscription.getRepository() != null) {
                            InstanceNotificationPublisher publisher = new InstanceNotificationPublisher();
                            publisher.sendArtifactUpdateEvent(cartridgeSubscription.getRepository(), clusterId, String.valueOf(cartridgeSubscription.getSubscriber().getTenantId()));
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("No repository found for subscription with alias: " + cartridgeSubscription.getAlias() + ", type: " + cartridgeSubscription.getType() + ". Not sending the Artifact Updated event"));
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)"Could not process instance status message", (Throwable)e);
            }
        }
    }
}

