/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.lb.category;

import java.rmi.RemoteException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.ClusterContext;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.manager.client.AutoscalerServiceClient;
import org.apache.stratos.manager.client.CloudControllerServiceClient;
import org.apache.stratos.manager.dao.Cluster;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.AlreadySubscribedException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.lb.category.LoadBalancerCategory;
import org.apache.stratos.manager.payload.PayloadData;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.subscriber.Subscriber;

public class ServiceLevelLoadBalancerCategory
extends LoadBalancerCategory {
    private static Log log = LogFactory.getLog(ServiceLevelLoadBalancerCategory.class);
    private boolean serviceLbExists;

    @Override
    public PayloadData create(String alias, Cluster cluster, Subscriber subscriber, Repository repository, CartridgeInfo cartridgeInfo, String subscriptionKey, Map<String, String> customPayloadEntries) throws ADCException, AlreadySubscribedException {
        String clusterId = null;
        try {
            clusterId = AutoscalerServiceClient.getServiceClient().getServiceLBClusterId(this.getLoadBalancedServiceType(), this.getDeploymentPolicyName());
        }
        catch (Exception e) {
            log.error((Object)("Error occurred in retrieving Service LB cluster id" + e.getMessage()));
            throw new ADCException(e);
        }
        if (clusterId != null) {
            ClusterContext clusterContext;
            cluster.setClusterDomain(clusterId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set existing Service LB cluster id " + clusterId));
            }
            this.serviceLbExists = true;
            try {
                clusterContext = CloudControllerServiceClient.getServiceClient().getClusterContext(clusterId);
            }
            catch (RemoteException e) {
                log.error((Object)"Error occurred in retrieving Cluster Context for Service LB ", (Throwable)e);
                throw new ADCException(e);
            }
            if (clusterContext != null) {
                cluster.setHostName(clusterContext.getHostName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set existing Service LB hostname " + clusterContext.getHostName()));
                }
            }
            return null;
        }
        cluster.setClusterDomain(this.generateClusterId(alias, cartridgeInfo.getType()));
        cluster.setHostName(this.generateHostName(alias, cartridgeInfo.getHostName()));
        PayloadData serviceLevelLbPayloadData = this.createPayload(cartridgeInfo, subscriptionKey, subscriber, cluster, repository, alias, customPayloadEntries);
        serviceLevelLbPayloadData.add("LOAD_BALANCED_SERVICE_TYPE", this.getLoadBalancedServiceType());
        return serviceLevelLbPayloadData;
    }

    @Override
    public void register(CartridgeInfo cartridgeInfo, Cluster cluster, PayloadData payloadData, String autoscalePolicyName, String deploymentPolicyName, Properties properties) throws ADCException, UnregisteredCartridgeException {
        if (!this.serviceLbExists) {
            if (payloadData != null) {
                log.info((Object)("Payload: " + payloadData.getCompletePayloadData().toString()));
            }
            super.register(cartridgeInfo, cluster, payloadData, autoscalePolicyName, deploymentPolicyName, properties);
        } else {
            log.info((Object)("Service LB already exists for cartridge type: " + this.getLoadBalancedServiceType() + ", deployment policy: " + this.getDeploymentPolicyName()));
        }
    }
}

