/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.topology.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.deploy.service.Service;
import org.apache.stratos.manager.exception.PersistenceManagerException;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.messaging.domain.topology.Cluster;

public class TopologyClusterInformationModel {
    private static final Log log = LogFactory.getLog(TopologyClusterInformationModel.class);
    private static TopologyClusterInformationModel topologyClusterInformationModel;
    private Map<String, Cluster> clusterIdToClusterMap = new HashMap<String, Cluster>();
    private DataInsertionAndRetrievalManager dataInsertionNRetrievalMgr = new DataInsertionAndRetrievalManager();
    private boolean initialized;
    private static volatile ReentrantReadWriteLock lock;
    private static volatile ReentrantReadWriteLock.WriteLock writeLock;

    private TopologyClusterInformationModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyClusterInformationModel getInstance() {
        if (topologyClusterInformationModel != null) return topologyClusterInformationModel;
        Class<TopologyClusterInformationModel> clazz = TopologyClusterInformationModel.class;
        synchronized (TopologyClusterInformationModel.class) {
            if (topologyClusterInformationModel != null) return topologyClusterInformationModel;
            topologyClusterInformationModel = new TopologyClusterInformationModel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return topologyClusterInformationModel;
        }
    }

    public void addCluster(Cluster cluster) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Adding cluster [" + cluster.getClusterId() + "] "));
        }
        this.clusterIdToClusterMap.put(cluster.getClusterId(), cluster);
    }

    public Cluster getCluster(int tenantId, String cartridgeType, String subscriptionAlias) {
        String clusterId = this.dataInsertionNRetrievalMgr.getCartridgeSubscription(tenantId, subscriptionAlias).getClusterDomain();
        Cluster cluster = this.clusterIdToClusterMap.get(clusterId);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Found cluster [" + cluster + "] with id [" + clusterId + "] "));
        }
        return cluster;
    }

    public Cluster getCluster(String cartridgeType) {
        Service service;
        Cluster cluster = null;
        try {
            service = this.dataInsertionNRetrievalMgr.getService(cartridgeType);
        }
        catch (PersistenceManagerException e) {
            log.error((Object)("Exception occurred when retrieving service [" + cartridgeType + "] "));
            return null;
        }
        if (service != null) {
            String clusterId = service.getClusterId();
            cluster = this.clusterIdToClusterMap.get(clusterId);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Found cluster [" + cluster + "] with id [" + clusterId + "] "));
            }
        }
        return cluster;
    }

    public Set<Cluster> getClusters(int tenantId, String cartridgeType) {
        if (log.isDebugEnabled()) {
            log.info((Object)(" Getting cluster for tenant id [" + tenantId + "] "));
        }
        Collection<CartridgeSubscription> subscriptions = null;
        subscriptions = cartridgeType != null ? this.dataInsertionNRetrievalMgr.getCartridgeSubscriptions(tenantId, cartridgeType) : this.dataInsertionNRetrievalMgr.getCartridgeSubscriptions(tenantId);
        HashSet<Cluster> clusterSet = new HashSet<Cluster>();
        if (subscriptions != null) {
            for (CartridgeSubscription cartridgeSubscription : subscriptions) {
                Cluster foundCluster;
                String clusterId = cartridgeSubscription.getClusterDomain();
                if (log.isDebugEnabled()) {
                    log.info((Object)("Finding cluster with id [" + clusterId + "] "));
                }
                if ((foundCluster = this.clusterIdToClusterMap.get(clusterId)) == null) continue;
                clusterSet.add(foundCluster);
            }
        }
        return clusterSet;
    }

    public void removeCluster(String clusterId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Removing cluster [" + clusterId + "] "));
        }
        this.clusterIdToClusterMap.remove(clusterId);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    static {
        lock = new ReentrantReadWriteLock(true);
        writeLock = lock.writeLock();
    }
}

