/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription.cache;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.subscription.cache.CartridgeInstanceCacheKey;

public class CartridgeInstanceCache {
    private static final Log log = LogFactory.getLog(CartridgeInstanceCache.class);
    private Map<CartridgeInstanceCacheKey, CartridgeSubscription> cartridgeInstanceKeyToCartridgeInstance = new ConcurrentHashMap<CartridgeInstanceCacheKey, CartridgeSubscription>();
    private final Map<Integer, List<CartridgeSubscription>> tenantIdToCartridgeInstance = new ConcurrentHashMap<Integer, List<CartridgeSubscription>>();
    private static CartridgeInstanceCache cartridgeInstanceCache;

    private CartridgeInstanceCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CartridgeInstanceCache getCartridgeInstanceCache() {
        if (cartridgeInstanceCache != null) return cartridgeInstanceCache;
        Class<CartridgeInstanceCache> clazz = CartridgeInstanceCache.class;
        synchronized (CartridgeInstanceCache.class) {
            if (cartridgeInstanceCache != null) return cartridgeInstanceCache;
            cartridgeInstanceCache = new CartridgeInstanceCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cartridgeInstanceCache;
        }
    }

    public void addCartridgeInstances(int tenantId, List<CartridgeSubscription> cartridgeSubscriptions) {
        for (CartridgeSubscription cartridgeSubscription : cartridgeSubscriptions) {
            this.addCartridgeInstance(new CartridgeInstanceCacheKey(tenantId, cartridgeSubscription.getAlias()), cartridgeSubscription);
        }
    }

    public void addCartridgeInstance(CartridgeInstanceCacheKey cartridgeInstanceCacheKey, CartridgeSubscription cartridgeSubscription) {
        this.cartridgeInstanceKeyToCartridgeInstance.put(cartridgeInstanceCacheKey, cartridgeSubscription);
        List<CartridgeSubscription> cartridgeSubscriptions = this.tenantIdToCartridgeInstance.get(cartridgeInstanceCacheKey.getTenantId());
        if (cartridgeSubscriptions != null) {
            cartridgeSubscriptions.add(cartridgeSubscription);
        } else {
            cartridgeSubscriptions = new Vector<CartridgeSubscription>();
            cartridgeSubscriptions.add(cartridgeSubscription);
            this.tenantIdToCartridgeInstance.put(cartridgeInstanceCacheKey.getTenantId(), cartridgeSubscriptions);
        }
        log.info((Object)("Added tenant " + cartridgeInstanceCacheKey.getTenantId() + "'s cartridge subscription with alias " + cartridgeInstanceCacheKey.getCartridgeInstanceAlias() + " to the cache"));
    }

    public CartridgeSubscription getCartridgeInstance(CartridgeInstanceCacheKey cartridgeInstanceCacheKey) {
        return this.cartridgeInstanceKeyToCartridgeInstance.get(cartridgeInstanceCacheKey);
    }

    public List<CartridgeSubscription> getCartridgeInstances(int tenantId) {
        return this.tenantIdToCartridgeInstance.get(tenantId);
    }

    public boolean alreadyExists(CartridgeInstanceCacheKey cartridgeInstanceCacheKey) {
        return this.cartridgeInstanceKeyToCartridgeInstance.containsKey(cartridgeInstanceCacheKey);
    }

    public void removeCartridgeInstances(int tenantId) {
        List<CartridgeSubscription> cartridgeSubscriptions = this.tenantIdToCartridgeInstance.get(tenantId);
        for (CartridgeSubscription cartridgeSubscription : cartridgeSubscriptions) {
            this.removeCartridgeInstance(new CartridgeInstanceCacheKey(tenantId, cartridgeSubscription.getAlias()));
        }
    }

    public void removeCartridgeInstance(CartridgeInstanceCacheKey cartridgeInstanceCacheKey) {
        if (this.cartridgeInstanceKeyToCartridgeInstance.remove(cartridgeInstanceCacheKey) != null && this.tenantIdToCartridgeInstance.remove(cartridgeInstanceCacheKey.getTenantId()) != null) {
            log.info((Object)("Removed tenant " + cartridgeInstanceCacheKey.getTenantId() + "'s cartridge subscription with alias " + cartridgeInstanceCacheKey.getCartridgeInstanceAlias() + " from the cache"));
        }
    }
}

