/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.manager.dao.CartridgeSubscriptionInfo;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.AlreadySubscribedException;
import org.apache.stratos.manager.exception.DuplicateCartridgeAliasException;
import org.apache.stratos.manager.exception.InvalidCartridgeAliasException;
import org.apache.stratos.manager.exception.InvalidRepositoryException;
import org.apache.stratos.manager.exception.NotSubscribedException;
import org.apache.stratos.manager.exception.PolicyException;
import org.apache.stratos.manager.exception.RepositoryCredentialsRequiredException;
import org.apache.stratos.manager.exception.RepositoryRequiredException;
import org.apache.stratos.manager.exception.RepositoryTransportException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.lb.category.LoadBalancerCategory;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.subscriber.Subscriber;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionTenancyBehaviour;
import org.apache.stratos.manager.utils.ApplicationManagementUtil;

public class LBCartridgeSubscription
extends CartridgeSubscription {
    private LoadBalancerCategory loadBalancerCategory;
    private static Log log = LogFactory.getLog(LBCartridgeSubscription.class);

    public LBCartridgeSubscription(CartridgeInfo cartridgeInfo, SubscriptionTenancyBehaviour subscriptionTenancyBehaviour, LoadBalancerCategory loadBalancerCategory) {
        super(cartridgeInfo, subscriptionTenancyBehaviour);
        this.setLoadBalancerCategory(loadBalancerCategory);
    }

    @Override
    public void createSubscription(Subscriber subscriber, String alias, String autoscalingPolicy, String deploymentPolicyName, Repository repository) throws ADCException, PolicyException, UnregisteredCartridgeException, InvalidCartridgeAliasException, DuplicateCartridgeAliasException, RepositoryRequiredException, AlreadySubscribedException, RepositoryCredentialsRequiredException, InvalidRepositoryException, RepositoryTransportException {
        this.setSubscriber(subscriber);
        this.setAlias(alias);
        this.setAutoscalingPolicyName(autoscalingPolicy);
        this.setDeploymentPolicyName(deploymentPolicyName);
        this.setRepository(repository);
        if (!this.loadBalancerCategory.isLoadBalancedServiceMultiTenant()) {
            this.setPayloadData(this.getLoadBalancerCategory().create(this.getAlias(), this.getCluster(), this.getSubscriber(), this.getRepository(), this.getCartridgeInfo(), this.getSubscriptionKey(), this.getCustomPayloadEntries()));
        }
    }

    @Override
    public CartridgeSubscriptionInfo registerSubscription(Properties properties) throws ADCException, UnregisteredCartridgeException {
        if (!this.loadBalancerCategory.isLoadBalancedServiceMultiTenant()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Loadbalanced service is single tenant.");
            }
            this.getLoadBalancerCategory().register(this.getCartridgeInfo(), this.getCluster(), this.getPayloadData(), this.getAutoscalingPolicyName(), this.getDeploymentPolicyName(), properties);
        }
        return ApplicationManagementUtil.createCartridgeSubscription(this.getCartridgeInfo(), this.getAutoscalingPolicyName(), this.getType(), this.getAlias(), this.getSubscriber().getTenantId(), this.getSubscriber().getTenantDomain(), this.getRepository(), this.getCluster().getHostName(), this.getCluster().getClusterDomain(), this.getCluster().getClusterSubDomain(), this.getCluster().getMgtClusterDomain(), this.getCluster().getMgtClusterSubDomain(), null, this.getSubscriptionStatus(), this.getSubscriptionKey());
    }

    @Override
    public void removeSubscription() throws ADCException, NotSubscribedException {
        this.getLoadBalancerCategory().remove(this.getCluster().getClusterDomain(), this.getAlias());
    }

    @Override
    public Repository manageRepository(String repoURL, String repoUserName, String repoUserPassword, boolean privateRepo) {
        return null;
    }

    public LoadBalancerCategory getLoadBalancerCategory() {
        return this.loadBalancerCategory;
    }

    public void setLoadBalancerCategory(LoadBalancerCategory loadBalancerCategory) {
        this.loadBalancerCategory = loadBalancerCategory;
    }
}

