/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.subscription;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.InvalidRepositoryException;
import org.apache.stratos.manager.exception.RepositoryCredentialsRequiredException;
import org.apache.stratos.manager.exception.RepositoryRequiredException;
import org.apache.stratos.manager.exception.RepositoryTransportException;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.service.RepositoryInfoBean;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.subscription.tenancy.SubscriptionTenancyBehaviour;
import org.apache.stratos.manager.utils.RepositoryCreator;

public class InternalRepoBasedCartridgeSubscription
extends CartridgeSubscription {
    private static final long serialVersionUID = -1869600699603408517L;
    private static final Log log = LogFactory.getLog(InternalRepoBasedCartridgeSubscription.class);

    public InternalRepoBasedCartridgeSubscription(CartridgeInfo cartridgeInfo, SubscriptionTenancyBehaviour subscriptionTenancyBehaviour) {
        super(cartridgeInfo, subscriptionTenancyBehaviour);
    }

    @Override
    public Repository manageRepository(String repoURL, String repoUserName, String repoUserPassword, boolean privateRepo) throws ADCException, RepositoryRequiredException, RepositoryCredentialsRequiredException, RepositoryTransportException, InvalidRepositoryException {
        Repository repository = null;
        String defaultRepoUserName = System.getProperty("internal.repo.username");
        String defaultRepoPassword = System.getProperty("internal.repo.password");
        String[] dirArray = null;
        RepositoryInfoBean repoInfoBean = new RepositoryInfoBean(repoURL, this.getAlias(), this.getSubscriber().getTenantDomain(), defaultRepoUserName, defaultRepoPassword, dirArray);
        RepositoryCreator repoCreator = new RepositoryCreator(repoInfoBean);
        try {
            repository = repoCreator.createInternalRepository();
        }
        catch (Exception e) {
            String msg = "Error occurred in creating internal repository. ";
            log.error((Object)(msg + e.getMessage()));
            throw new ADCException(msg);
        }
        return repository;
    }
}

