/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.publisher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.TenantInfoBean;
import org.apache.stratos.common.exception.StratosException;
import org.apache.stratos.common.listeners.TenantMgtListener;
import org.apache.stratos.messaging.broker.publish.EventPublisher;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.domain.tenant.Tenant;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.event.tenant.TenantCreatedEvent;
import org.apache.stratos.messaging.event.tenant.TenantRemovedEvent;
import org.apache.stratos.messaging.event.tenant.TenantUpdatedEvent;

public class TenantEventPublisher
implements TenantMgtListener {
    private static final Log log = LogFactory.getLog(TenantEventPublisher.class);
    private static final int EXEC_ORDER = 1;

    public void onTenantCreate(TenantInfoBean tenantInfo) throws StratosException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Publishing tenant created event: [tenant-id] %d [tenant-domain] %s", tenantInfo.getTenantId(), tenantInfo.getTenantDomain()));
            }
            Tenant tenant = new Tenant(tenantInfo.getTenantId(), tenantInfo.getTenantDomain());
            TenantCreatedEvent event = new TenantCreatedEvent(tenant);
            EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)"tenant");
            eventPublisher.publish((Event)event);
        }
        catch (Exception e) {
            log.error((Object)"Could not publish tenant created event", (Throwable)e);
        }
    }

    public void onTenantUpdate(TenantInfoBean tenantInfo) throws StratosException {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Publishing tenant updated event: [tenant-id] %d [tenant-domain] %s", tenantInfo.getTenantId(), tenantInfo.getTenantDomain()));
            }
            TenantUpdatedEvent event = new TenantUpdatedEvent(tenantInfo.getTenantId(), tenantInfo.getTenantDomain());
            EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)"tenant");
            eventPublisher.publish((Event)event);
        }
        catch (Exception e) {
            log.error((Object)"Could not publish tenant updated event");
        }
    }

    public void onTenantDelete(int tenantId) {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Publishing tenant removed event: [tenant-id] %d", tenantId));
            }
            TenantRemovedEvent event = new TenantRemovedEvent(tenantId);
            EventPublisher eventPublisher = EventPublisherPool.getPublisher((String)"tenant");
            eventPublisher.publish((Event)event);
        }
        catch (Exception e) {
            log.error((Object)"Could not publish tenant removed event");
        }
    }

    public void onTenantRename(int tenantId, String oldDomainName, String newDomainName) throws StratosException {
    }

    public void onTenantInitialActivation(int tenantId) throws StratosException {
    }

    public void onTenantActivation(int tenantId) throws StratosException {
    }

    public void onTenantDeactivation(int tenantId) throws StratosException {
    }

    public void onSubscriptionPlanChange(int tenantId, String oldPlan, String newPlan) throws StratosException {
    }

    public int getListenerOrder() {
        return 1;
    }
}

