/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.deploy.service.Service;
import org.apache.stratos.manager.exception.PersistenceManagerException;
import org.apache.stratos.manager.persistence.PersistenceManager;
import org.apache.stratos.manager.registry.RegistryManager;
import org.apache.stratos.manager.subscription.CartridgeSubscription;
import org.apache.stratos.manager.utils.Deserializer;
import org.apache.stratos.manager.utils.Serializer;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryBasedPersistenceManager
extends PersistenceManager {
    private static final Log log = LogFactory.getLog(RegistryBasedPersistenceManager.class);
    private static final String STRATOS_MANAGER_REOSURCE = "/stratos_manager";
    private static final String ACTIVE_SUBSCRIPTIONS = "/subscriptions/active";
    private static final String INACTIVE_SUBSCRIPTIONS = "/subscriptions/inactive";
    private static final String SERVICES = "/services";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistCartridgeSubscription(CartridgeSubscription cartridgeSubscription) throws PersistenceManagerException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId != -1234) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                this.persistSubscription(cartridgeSubscription);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        } else {
            this.persistSubscription(cartridgeSubscription);
        }
    }

    private void persistSubscription(CartridgeSubscription cartridgeSubscription) throws PersistenceManagerException {
        try {
            RegistryManager.getInstance().persist("/stratos_manager/subscriptions/active/" + Integer.toString(cartridgeSubscription.getSubscriber().getTenantId()) + "/" + cartridgeSubscription.getType() + "/" + cartridgeSubscription.getAlias(), Serializer.serializeSubscriptionSontextToByteArray(cartridgeSubscription), cartridgeSubscription.getClusterDomain());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persisted CartridgeSubscription successfully: [ " + cartridgeSubscription.getSubscriber().getTenantDomain() + ", " + cartridgeSubscription.getType() + ", " + cartridgeSubscription.getAlias() + " ] "));
            }
        }
        catch (RegistryException e) {
            throw new PersistenceManagerException(e);
        }
        catch (IOException e) {
            throw new PersistenceManagerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCartridgeSubscription(int tenantId, String type, String alias) throws PersistenceManagerException {
        if (tenantId != -1234) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                this.removeSubscription(tenantId, type, alias);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        } else {
            this.removeSubscription(tenantId, type, alias);
        }
    }

    private void removeSubscription(int tenantId, String type, String alias) throws PersistenceManagerException {
        String sourcePath = "/stratos_manager/subscriptions/active/" + Integer.toString(tenantId) + "/" + type + "/" + alias;
        String targetPath = "/stratos_manager/subscriptions/inactive/" + Integer.toString(tenantId) + "/" + type + "/" + alias;
        try {
            RegistryManager.getInstance().move(sourcePath, targetPath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Moved CartridgeSubscription on " + sourcePath + " to " + targetPath + " successfully"));
            }
        }
        catch (RegistryException e) {
            throw new PersistenceManagerException(e);
        }
    }

    @Override
    public Collection<CartridgeSubscription> getCartridgeSubscriptions() throws PersistenceManagerException {
        return this.traverseAndGetCartridgeSubscriptions("/stratos_manager/subscriptions/active");
    }

    private Collection<CartridgeSubscription> traverseAndGetCartridgeSubscriptions(String resourcePath) throws PersistenceManagerException {
        Object resourceObj;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root resource path: " + resourcePath));
        }
        try {
            resourceObj = RegistryManager.getInstance().retrieve(resourcePath);
        }
        catch (RegistryException e) {
            throw new PersistenceManagerException(e);
        }
        ArrayList<CartridgeSubscription> cartridgeSubscriptions = new ArrayList<CartridgeSubscription>();
        if (resourceObj == null) {
            return null;
        }
        if (resourceObj instanceof String[]) {
            String[] subscriptionResourcePaths = (String[])resourceObj;
            if (log.isDebugEnabled()) {
                for (String retrievedResourcePath : subscriptionResourcePaths) {
                    log.debug((Object)("Retrieved resource sub-path " + retrievedResourcePath));
                }
            }
            for (String subscriptionResourcePath : subscriptionResourcePaths) {
                Collection<CartridgeSubscription> cartridgeSubscriptionSet;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Traversing resource path " + subscriptionResourcePath));
                }
                if ((cartridgeSubscriptionSet = this.traverseAndGetCartridgeSubscriptions(subscriptionResourcePath)) == null) continue;
                cartridgeSubscriptions.addAll(cartridgeSubscriptionSet);
            }
        } else {
            Object subscriptionObj;
            try {
                subscriptionObj = Deserializer.deserializeFromByteArray((byte[])resourceObj);
            }
            catch (Exception e) {
                log.error((Object)("Error while de-serializing the object retrieved from " + resourcePath), (Throwable)e);
                return null;
            }
            if (subscriptionObj != null && subscriptionObj instanceof CartridgeSubscription) {
                CartridgeSubscription deserilizedCartridgeSubscription = (CartridgeSubscription)subscriptionObj;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully de-serialized CartridgeSubscription: " + deserilizedCartridgeSubscription.toString()));
                }
                cartridgeSubscriptions.add(deserilizedCartridgeSubscription);
            }
        }
        cartridgeSubscriptions.removeAll(Collections.singleton(null));
        return cartridgeSubscriptions;
    }

    @Override
    public Collection<CartridgeSubscription> getCartridgeSubscriptions(int tenantId) throws PersistenceManagerException {
        return this.traverseAndGetCartridgeSubscriptions("/stratos_manager/subscriptions/active/" + Integer.toString(tenantId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistService(Service service) throws PersistenceManagerException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId != -1234) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                this.persistDeployedService(service);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        } else {
            this.persistDeployedService(service);
        }
    }

    private void persistDeployedService(Service service) throws PersistenceManagerException {
        try {
            RegistryManager.getInstance().persist("/stratos_manager/services/" + service.getType(), Serializer.serializeServiceToByteArray(service), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persisted Service successfully: [ " + service.getType() + ", " + service.getTenantRange() + " ]"));
            }
        }
        catch (RegistryException e) {
            throw new PersistenceManagerException(e);
        }
        catch (IOException e) {
            throw new PersistenceManagerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Service> getServices() throws PersistenceManagerException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId != -1234) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                Collection<Service> collection = this.traverseAndGetDeloyedServices("/stratos_manager/services");
                return collection;
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return this.traverseAndGetDeloyedServices("/stratos_manager/services");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getService(String cartridgeType) throws PersistenceManagerException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId != -1234) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                Service service = this.getDeployedService(cartridgeType);
                return service;
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return this.getDeployedService(cartridgeType);
    }

    public Collection<Service> traverseAndGetDeloyedServices(String resourcePath) throws PersistenceManagerException {
        Object resourceObj;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root resource path: " + resourcePath));
        }
        try {
            resourceObj = RegistryManager.getInstance().retrieve(resourcePath);
        }
        catch (RegistryException e) {
            throw new PersistenceManagerException(e);
        }
        ArrayList<Service> services = new ArrayList<Service>();
        if (resourceObj == null) {
            return null;
        }
        if (resourceObj instanceof String[]) {
            String[] serviceResourcePaths = (String[])resourceObj;
            if (log.isDebugEnabled()) {
                for (String retrievedResourcePath : serviceResourcePaths) {
                    log.debug((Object)("Retrieved resource sub-path " + retrievedResourcePath));
                }
            }
            for (String serviceResourcePath : serviceResourcePaths) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Traversing resource path " + serviceResourcePath));
                }
                services.addAll(this.traverseAndGetDeloyedServices(serviceResourcePath));
            }
        } else {
            Object serviceObj;
            try {
                serviceObj = Deserializer.deserializeFromByteArray((byte[])resourceObj);
            }
            catch (Exception e) {
                log.error((Object)("Error while de-serializing the object retrieved from " + resourcePath), (Throwable)e);
                return null;
            }
            if (serviceObj != null && serviceObj instanceof Service) {
                Service deserilizedService = (Service)serviceObj;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully de-serialized Service: " + deserilizedService.toString()));
                }
                services.add(deserilizedService);
            }
        }
        services.removeAll(Collections.singleton(null));
        return services;
    }

    public Service getDeployedService(String cartridgeType) throws PersistenceManagerException {
        Object serviceObj;
        Object byteObj;
        try {
            byteObj = RegistryManager.getInstance().retrieve("/stratos_manager/services/" + cartridgeType);
        }
        catch (RegistryException e) {
            throw new PersistenceManagerException(e);
        }
        if (byteObj == null) {
            return null;
        }
        try {
            serviceObj = Deserializer.deserializeFromByteArray((byte[])byteObj);
        }
        catch (Exception e) {
            throw new PersistenceManagerException(e);
        }
        if (serviceObj instanceof Service) {
            return (Service)serviceObj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(String cartridgeType) throws PersistenceManagerException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId != -1234) {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                carbonContext.setTenantDomain("carbon.super");
                carbonContext.setTenantId(-1234);
                this.removeDeployedService(cartridgeType);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        } else {
            this.removeDeployedService(cartridgeType);
        }
    }

    private void removeDeployedService(String cartridgeType) throws PersistenceManagerException {
        String resourcePath = "/stratos_manager/services/" + cartridgeType;
        try {
            RegistryManager.getInstance().delete(resourcePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleted Service on path " + resourcePath + " successfully"));
            }
        }
        catch (RegistryException e) {
            throw new PersistenceManagerException(e);
        }
    }
}

