/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.lookup.SubscriptionContext;

public class TenantIdToSubscriptionContext {
    private static final Log log = LogFactory.getLog(TenantIdToSubscriptionContext.class);
    private Map<Integer, SubscriptionContext> tenantIdToSubscriptionContext = new HashMap<Integer, SubscriptionContext>();

    public Collection<SubscriptionContext> getSubscriptionContexts() {
        return this.tenantIdToSubscriptionContext.values();
    }

    public SubscriptionContext getSubscriptionContext(int tenantId) {
        return this.tenantIdToSubscriptionContext.get(tenantId);
    }

    public void addSubscriptionContext(int tenantId, SubscriptionContext subscriptionContext) {
        this.tenantIdToSubscriptionContext.put(tenantId, subscriptionContext);
    }

    public void removeSubscriptionContext(int tenantId, String type, String subscriptionAlias) {
        if (this.tenantIdToSubscriptionContext.containsKey(tenantId)) {
            SubscriptionContext subscriptionContext = this.tenantIdToSubscriptionContext.get(tenantId);
            subscriptionContext.deleteSubscription(type, subscriptionAlias);
            if (subscriptionContext.isEmpty()) {
                this.tenantIdToSubscriptionContext.remove(tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleted the subscriptionContext instance for tenant " + tenantId));
                }
            }
        }
    }
}

