/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.manager.lookup.ClusterIdToSubscription;
import org.apache.stratos.manager.lookup.RepoUrlToCartridgeSubscriptions;
import org.apache.stratos.manager.lookup.SubscriptionContext;
import org.apache.stratos.manager.lookup.TenantIdToSubscriptionContext;
import org.apache.stratos.manager.subscription.CartridgeSubscription;

public class LookupDataHolder
implements Serializable {
    private static final Log log = LogFactory.getLog(LookupDataHolder.class);
    private ClusterIdToSubscription clusterIdToSubscription = new ClusterIdToSubscription();
    private TenantIdToSubscriptionContext tenantIdToSubscriptionContext = new TenantIdToSubscriptionContext();
    private RepoUrlToCartridgeSubscriptions repoUrlToCartridgeSubscriptions = new RepoUrlToCartridgeSubscriptions();
    private static volatile LookupDataHolder lookupDataHolder;
    private static volatile ReentrantReadWriteLock lock;
    private static volatile ReentrantReadWriteLock.WriteLock writeLock;
    private static volatile ReentrantReadWriteLock.ReadLock readLock;

    private LookupDataHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LookupDataHolder getInstance() {
        if (lookupDataHolder != null) return lookupDataHolder;
        Class<LookupDataHolder> clazz = LookupDataHolder.class;
        synchronized (LookupDataHolder.class) {
            if (lookupDataHolder != null) return lookupDataHolder;
            lookupDataHolder = new LookupDataHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return lookupDataHolder;
        }
    }

    public void putSubscription(CartridgeSubscription cartridgeSubscription) {
        this.clusterIdToSubscription.addSubscription(cartridgeSubscription);
        this.repoUrlToCartridgeSubscriptions.addSubscription(cartridgeSubscription);
        SubscriptionContext existingSubscriptionCtx = this.tenantIdToSubscriptionContext.getSubscriptionContext(cartridgeSubscription.getSubscriber().getTenantId());
        if (existingSubscriptionCtx != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Existing SubscriptionContext found for tenant " + cartridgeSubscription.getSubscriber().getTenantId()));
            }
            existingSubscriptionCtx.addSubscription(cartridgeSubscription);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Existing SubscriptionContext not found for tenant " + cartridgeSubscription.getSubscriber().getTenantId()));
            }
            SubscriptionContext subscriptionContext = new SubscriptionContext();
            subscriptionContext.addSubscription(cartridgeSubscription);
            this.tenantIdToSubscriptionContext.addSubscriptionContext(cartridgeSubscription.getSubscriber().getTenantId(), subscriptionContext);
        }
    }

    public void removeSubscription(int tenantId, String type, String subscriptionAlias, String clusterId, String repoUrl) {
        this.tenantIdToSubscriptionContext.removeSubscriptionContext(tenantId, type, subscriptionAlias);
        this.clusterIdToSubscription.removeSubscription(clusterId, subscriptionAlias);
        this.repoUrlToCartridgeSubscriptions.removeSubscription(repoUrl, subscriptionAlias);
    }

    public Collection<CartridgeSubscription> getSubscriptions(String cartridgeType) {
        Collection<SubscriptionContext> subscriptionContexts = this.tenantIdToSubscriptionContext.getSubscriptionContexts();
        if (subscriptionContexts == null) {
            return null;
        }
        ArrayList<CartridgeSubscription> cartridgeSubscriptions = new ArrayList<CartridgeSubscription>();
        for (SubscriptionContext subscriptionContext : subscriptionContexts) {
            Collection<CartridgeSubscription> cartridgeSubscriptionsOfType = subscriptionContext.getSubscriptionsOfType(cartridgeType);
            if (cartridgeSubscriptionsOfType == null || cartridgeSubscriptionsOfType.isEmpty()) continue;
            cartridgeSubscriptions.addAll(cartridgeSubscriptionsOfType);
        }
        return cartridgeSubscriptions;
    }

    public Collection<CartridgeSubscription> getSubscriptions(int tenantId) {
        SubscriptionContext subscriptionContext = this.tenantIdToSubscriptionContext.getSubscriptionContext(tenantId);
        if (subscriptionContext == null) {
            return null;
        }
        return subscriptionContext.getSubscriptions();
    }

    public CartridgeSubscription getSubscriptionForAlias(String subscriptionAlias) {
        Collection<SubscriptionContext> subscriptionContexts = this.tenantIdToSubscriptionContext.getSubscriptionContexts();
        if (subscriptionContexts == null) {
            return null;
        }
        for (SubscriptionContext subscriptionContext : subscriptionContexts) {
            CartridgeSubscription cartridgeSubscription = subscriptionContext.getSubscriptionForAlias(subscriptionAlias);
            if (cartridgeSubscription == null) continue;
            return cartridgeSubscription;
        }
        return null;
    }

    public Collection<CartridgeSubscription> getSubscriptionForType(int tenantId, String cartridgeType) {
        SubscriptionContext subscriptionContext = this.tenantIdToSubscriptionContext.getSubscriptionContext(tenantId);
        if (subscriptionContext == null) {
            return null;
        }
        return subscriptionContext.getSubscriptionsOfType(cartridgeType);
    }

    public CartridgeSubscription getSubscriptionForAlias(int tenantId, String subscriptionAlias) {
        SubscriptionContext subscriptionContext = this.tenantIdToSubscriptionContext.getSubscriptionContext(tenantId);
        if (subscriptionContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No SubscriptionContext found for tenant " + tenantId + ", subscription alias " + subscriptionAlias));
            }
            return null;
        }
        return subscriptionContext.getSubscriptionForAlias(subscriptionAlias);
    }

    public Set<CartridgeSubscription> getSubscription(String clusterId) {
        return this.clusterIdToSubscription.getSubscription(clusterId);
    }

    public Set<CartridgeSubscription> getSubscriptionsForRepoUrl(String repoUrl) {
        return this.repoUrlToCartridgeSubscriptions.getSubscriptions(repoUrl);
    }

    public void acquireWriteLock() {
        writeLock.lock();
    }

    public void releaseWriteLock() {
        writeLock.unlock();
    }

    public void acquireReadLock() {
        readLock.lock();
    }

    public void releaseReadLock() {
        readLock.unlock();
    }

    static {
        lock = new ReentrantReadWriteLock(true);
        writeLock = lock.writeLock();
        readLock = lock.readLock();
    }
}

