/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.internal;

import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.listeners.TenantMgtListener;
import org.apache.stratos.manager.internal.DataHolder;
import org.apache.stratos.manager.internal.ServiceReferenceHolder;
import org.apache.stratos.manager.listener.InstanceStatusListener;
import org.apache.stratos.manager.publisher.TenantEventPublisher;
import org.apache.stratos.manager.publisher.TenantSynchronizerTaskScheduler;
import org.apache.stratos.manager.retriever.DataInsertionAndRetrievalManager;
import org.apache.stratos.manager.topology.receiver.StratosManagerTopologyEventReceiver;
import org.apache.stratos.manager.utils.CartridgeConfigFileReader;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.broker.subscribe.TopicSubscriber;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ADCManagementServerComponent {
    private static final Log log = LogFactory.getLog(ADCManagementServerComponent.class);
    private StratosManagerTopologyEventReceiver stratosManagerTopologyEventReceiver;

    protected void activate(ComponentContext componentContext) throws Exception {
        block5: {
            try {
                CartridgeConfigFileReader.readProperties();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Scheduling tenant synchronizer task...");
                }
                TenantSynchronizerTaskScheduler.schedule(ServiceReferenceHolder.getInstance().getTaskService());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starting tenant event publisher...");
                }
                TenantEventPublisher tenantEventPublisher = new TenantEventPublisher();
                componentContext.getBundleContext().registerService(TenantMgtListener.class.getName(), (Object)tenantEventPublisher, null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starting instance status topic subscriber...");
                }
                TopicSubscriber subscriber = new TopicSubscriber("instance-status");
                subscriber.setMessageListener((MessageListener)new InstanceStatusListener());
                Thread tsubscriber = new Thread((Runnable)subscriber);
                tsubscriber.start();
                this.stratosManagerTopologyEventReceiver = new StratosManagerTopologyEventReceiver();
                Thread topologyReceiverThread = new Thread(this.stratosManagerTopologyEventReceiver);
                topologyReceiverThread.start();
                log.info((Object)"Topology receiver thread started");
                new DataInsertionAndRetrievalManager().cachePersistedSubscriptions();
                log.info((Object)"ADC management server component is activated");
            }
            catch (Exception e) {
                if (!log.isFatalEnabled()) break block5;
                log.fatal((Object)"Could not activate ADC management server component", (Throwable)e);
            }
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.setClientConfigContext(contextService.getClientConfigContext());
        DataHolder.setServerConfigContext(contextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        DataHolder.setClientConfigContext(null);
        DataHolder.setServerConfigContext(null);
    }

    protected void setRealmService(RealmService realmService) {
        DataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            DataHolder.setRegistryService(registryService);
        }
        catch (Exception e) {
            log.error((Object)"Cannot retrieve governance registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    protected void setTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the task service");
        }
        ServiceReferenceHolder.getInstance().setTaskService(taskService);
    }

    protected void unsetTaskService(TaskService taskService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Un-setting the task service");
        }
        ServiceReferenceHolder.getInstance().setTaskService(null);
    }

    protected void deactivate(ComponentContext context) {
        EventPublisherPool.close((String)"instance-notifier");
        EventPublisherPool.close((String)"tenant");
        this.stratosManagerTopologyEventReceiver.terminate();
    }
}

