/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.manager.behaviour;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.cloud.controller.stub.pojo.CartridgeInfo;
import org.apache.stratos.cloud.controller.stub.pojo.Properties;
import org.apache.stratos.cloud.controller.stub.pojo.Property;
import org.apache.stratos.manager.client.CloudControllerServiceClient;
import org.apache.stratos.manager.dao.Cluster;
import org.apache.stratos.manager.exception.ADCException;
import org.apache.stratos.manager.exception.AlreadySubscribedException;
import org.apache.stratos.manager.exception.NotSubscribedException;
import org.apache.stratos.manager.exception.UnregisteredCartridgeException;
import org.apache.stratos.manager.payload.BasicPayloadData;
import org.apache.stratos.manager.payload.PayloadData;
import org.apache.stratos.manager.payload.PayloadFactory;
import org.apache.stratos.manager.repository.Repository;
import org.apache.stratos.manager.service.InstanceCleanupNotificationService;
import org.apache.stratos.manager.subscriber.Subscriber;
import org.apache.stratos.manager.subscription.utils.CartridgeSubscriptionUtils;
import org.apache.stratos.manager.utils.ApplicationManagementUtil;

public abstract class CartridgeMgtBehaviour
implements Serializable {
    private static final long serialVersionUID = 6529685098267757690L;
    private static Log log = LogFactory.getLog(CartridgeMgtBehaviour.class);

    public PayloadData create(String alias, Cluster cluster, Subscriber subscriber, Repository repository, CartridgeInfo cartridgeInfo, String subscriptionKey, Map<String, String> customPayloadEntries) throws ADCException, AlreadySubscribedException {
        cluster.setClusterDomain(this.generateClusterId(alias, cartridgeInfo.getType()));
        cluster.setHostName(this.generateHostName(alias, cartridgeInfo.getHostName()));
        return this.createPayload(cartridgeInfo, subscriptionKey, subscriber, cluster, repository, alias, customPayloadEntries);
    }

    protected String generateClusterId(String alias, String cartridgeType) {
        String clusterId = alias + "." + cartridgeType + ".domain";
        if (clusterId.length() > 30) {
            clusterId = CartridgeSubscriptionUtils.limitLengthOfString(clusterId, 30);
        }
        return clusterId;
    }

    protected String generateHostName(String alias, String cartridgeDefinitionHostName) {
        return alias + "." + cartridgeDefinitionHostName;
    }

    protected PayloadData createPayload(CartridgeInfo cartridgeInfo, String subscriptionKey, Subscriber subscriber, Cluster cluster, Repository repository, String alias, Map<String, String> customPayloadEntries) throws ADCException {
        BasicPayloadData basicPayloadData = CartridgeSubscriptionUtils.createBasicPayload(cartridgeInfo, subscriptionKey, cluster, repository, alias, subscriber);
        basicPayloadData.populatePayload();
        PayloadData payloadData = PayloadFactory.getPayloadDataInstance(cartridgeInfo.getProvider(), cartridgeInfo.getType(), basicPayloadData);
        if (cartridgeInfo.getProperties() != null && cartridgeInfo.getProperties().length != 0) {
            for (Property property : cartridgeInfo.getProperties()) {
                if (!property.getName().startsWith("payload_parameter.")) continue;
                String payloadParamName = property.getName();
                payloadData.add(payloadParamName.substring(payloadParamName.indexOf(".") + 1), property.getValue());
            }
        }
        if (customPayloadEntries != null) {
            Set<Map.Entry<String, String>> entrySet = customPayloadEntries.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                payloadData.add(entry.getKey(), entry.getValue());
            }
        }
        return payloadData;
    }

    public void register(CartridgeInfo cartridgeInfo, Cluster cluster, PayloadData payloadData, String autoscalePolicyName, String deploymentPolicyName, Properties properties) throws ADCException, UnregisteredCartridgeException {
        if (payloadData != null) {
            log.info((Object)("Payload: " + payloadData.getCompletePayloadData().toString()));
        } else {
            log.info((Object)"Payload is null");
        }
        ApplicationManagementUtil.registerService(cartridgeInfo.getType(), cluster.getClusterDomain(), cluster.getClusterSubDomain(), payloadData.getCompletePayloadData(), payloadData.getBasicPayloadData().getTenantRange(), cluster.getHostName(), autoscalePolicyName, deploymentPolicyName, properties);
    }

    public void remove(String clusterId, String alias) throws ADCException, NotSubscribedException {
        new InstanceCleanupNotificationService().sendInstanceCleanupNotificationForCluster(clusterId);
        log.info((Object)("Instance Cleanup Notification sent to Cluster:  " + clusterId));
        try {
            CloudControllerServiceClient.getServiceClient().unregisterService(clusterId);
        }
        catch (Exception e) {
            String errorMsg = "Error in unregistering service cluster with domain " + clusterId;
            log.error((Object)errorMsg);
            throw new ADCException(errorMsg, e);
        }
        log.info((Object)("Unregistered service cluster, domain " + clusterId));
    }
}

