/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.RefModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class SearchPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private boolean hasMore;

    public SearchPanel(String wicketId, final String repositoryName, final String objectId, String value, Constants.SearchType searchType, Repository r, int limit, int pageOffset, boolean showRemoteRefs) {
        super(wicketId);
        boolean pageResults = limit <= 0;
        int itemsPerPage = GitBlit.getInteger("web.itemsPerPage", 50);
        if (itemsPerPage <= 1) {
            itemsPerPage = 50;
        }
        RevCommit commit = JGitUtils.getCommit(r, objectId);
        final Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(r, showRemoteRefs);
        List<RevCommit> commits = pageResults ? JGitUtils.searchRevlogs(r, objectId, value, searchType, pageOffset * itemsPerPage, itemsPerPage) : JGitUtils.searchRevlogs(r, objectId, value, searchType, 0, limit);
        this.hasMore = commits.size() >= itemsPerPage;
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", repositoryName, commit)});
        this.add(new Component[]{new Label("searchString", value)});
        this.add(new Component[]{new Label("searchType", searchType.toString())});
        ListDataProvider dp = new ListDataProvider(commits);
        DataView<RevCommit> searchView = new DataView<RevCommit>("commit", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<RevCommit> item) {
                String shortMessage;
                RevCommit entry = (RevCommit)item.getModelObject();
                Date date = JGitUtils.getCommitDate(entry);
                item.add(new Component[]{WicketUtils.createDateLabel("commitDate", date, SearchPanel.this.getTimeZone(), SearchPanel.this.getTimeUtils())});
                String author = entry.getAuthorIdent().getName();
                LinkPanel authorLink = new LinkPanel("commitAuthor", "list", author, GitSearchPage.class, WicketUtils.newSearchParameter(repositoryName, objectId, author, Constants.SearchType.AUTHOR));
                SearchPanel.this.setPersonSearchTooltip((Component)authorLink, author, Constants.SearchType.AUTHOR);
                item.add(new Component[]{authorLink});
                if (entry.getParentCount() > 1) {
                    item.add(new Component[]{WicketUtils.newImage("commitIcon", "commit_merge_16x16.png")});
                } else {
                    item.add(new Component[]{WicketUtils.newBlankImage("commitIcon")});
                }
                String trimmedMessage = shortMessage = entry.getShortMessage();
                trimmedMessage = allRefs.containsKey(entry.getId()) ? StringUtils.trimString(shortMessage, 60) : StringUtils.trimString(shortMessage, 78);
                LinkPanel shortlog = new LinkPanel("commitShortMessage", "list subject", trimmedMessage, CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()));
                if (!shortMessage.equals(trimmedMessage)) {
                    WicketUtils.setHtmlTooltip((Component)shortlog, shortMessage);
                }
                item.add(new Component[]{shortlog});
                item.add(new Component[]{new RefsPanel("commitRefs", repositoryName, entry, allRefs)});
                item.add(new Component[]{new BookmarkablePageLink("commit", CommitPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                item.add(new Component[]{new BookmarkablePageLink("commitdiff", CommitDiffPage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                item.add(new Component[]{new BookmarkablePageLink("tree", TreePage.class, WicketUtils.newObjectParameter(repositoryName, entry.getName()))});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{searchView});
    }

    public boolean hasMore() {
        return this.hasMore;
    }
}

