/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.GitBlit;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.ShockWaveComponent;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.markup.html.panel.Fragment;

public class RepositoryUrlPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public RepositoryUrlPanel(String wicketId, String url) {
        super(wicketId);
        this.add(new Component[]{new Label("repositoryUrl", url)});
        if (GitBlit.getBoolean("web.allowFlashCopyToClipboard", true)) {
            Fragment fragment = new Fragment("copyFunction", "clippyPanel", (MarkupContainer)this);
            String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
            ShockWaveComponent clippy = new ShockWaveComponent("clippy", baseUrl + "/clippy.swf");
            clippy.setValue("flashVars", "text=" + StringUtils.encodeURL(url));
            fragment.add(new Component[]{clippy});
            this.add(new Component[]{fragment});
        } else {
            Fragment fragment = new Fragment("copyFunction", "jsPanel", (MarkupContainer)this);
            ContextImage img = WicketUtils.newImage("copyIcon", "clippy.png");
            img.add(new IBehavior[]{new BasePanel.JavascriptTextPrompt("onclick", "Copy to Clipboard (Ctrl+C, Enter)", url)});
            fragment.add(new Component[]{img});
            this.add(new Component[]{fragment});
        }
    }
}

