/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.SyndicationServlet;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.EditRepositoryPage;
import com.gitblit.wicket.pages.EmptyRepositoryPage;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class RepositoriesPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;

    public RepositoriesPanel(String wicketId, final boolean showAdmin, boolean showManagement, List<RepositoryModel> models, boolean enableLinks, final Map<Constants.AccessRestrictionType, String> accessRestrictionTranslations) {
        super(wicketId);
        Object dp;
        Fragment managementLinks;
        final boolean linksActive = enableLinks;
        final boolean showSize = GitBlit.getBoolean("web.showRepositorySizes", true);
        final UserModel user = GitBlitWebSession.get().getUser();
        if (showAdmin) {
            managementLinks = new Fragment("managementPanel", "adminLinks", (MarkupContainer)this);
            managementLinks.add(new Component[]{new Link<Void>("clearCache"){
                private static final long serialVersionUID = 1L;

                public void onClick() {
                    GitBlit.self().resetRepositoryListCache();
                    this.setResponsePage(RepositoriesPage.class);
                }
            }.setVisible(GitBlit.getBoolean("git.cacheRepositoryList", true))});
            managementLinks.add(new Component[]{new BookmarkablePageLink("newRepository", EditRepositoryPage.class)});
            this.add(new Component[]{managementLinks});
        } else if (showManagement && user != null && user.canCreate()) {
            managementLinks = new Fragment("managementPanel", "personalLinks", (MarkupContainer)this);
            managementLinks.add(new Component[]{new BookmarkablePageLink("newRepository", EditRepositoryPage.class)});
            this.add(new Component[]{managementLinks});
        } else {
            this.add(new Component[]{new Label("managementPanel").setVisible(false)});
        }
        if (GitBlit.getString("web.repositoryListType", "flat").equalsIgnoreCase("grouped")) {
            ArrayList<RepositoryModel> rootRepositories = new ArrayList<RepositoryModel>();
            HashMap groups = new HashMap();
            for (RepositoryModel model : models) {
                String rootPath = StringUtils.getRootPath(model.name);
                if (StringUtils.isEmpty(rootPath)) {
                    rootRepositories.add(model);
                    continue;
                }
                if (!groups.containsKey(rootPath)) {
                    groups.put(rootPath, new ArrayList());
                }
                ((List)groups.get(rootPath)).add(model);
            }
            ArrayList roots = new ArrayList(groups.keySet());
            Collections.sort(roots);
            if (rootRepositories.size() > 0) {
                String rootPath = GitBlit.getString("web.repositoryRootGroupName", " ");
                roots.add(0, rootPath);
                groups.put(rootPath, rootRepositories);
            }
            HashMap<String, ProjectModel> projects = new HashMap<String, ProjectModel>();
            for (ProjectModel project : GitBlit.self().getProjectModels(user, true)) {
                projects.put(project.name, project);
            }
            ArrayList<RepositoryModel> groupedModels = new ArrayList<RepositoryModel>();
            for (String root : roots) {
                List subModels = (List)groups.get(root);
                GroupRepositoryModel group = new GroupRepositoryModel(root, subModels.size());
                if (projects.containsKey(root)) {
                    group.title = ((ProjectModel)projects.get((Object)root)).title;
                    group.description = ((ProjectModel)projects.get((Object)root)).description;
                }
                groupedModels.add(group);
                Collections.sort(subModels);
                groupedModels.addAll(subModels);
            }
            dp = new RepositoriesProvider(groupedModels);
        } else {
            dp = new SortableRepositoriesProvider(models);
        }
        String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
        final boolean showSwatch = GitBlit.getBoolean("web.repositoryListSwatches", true);
        DataView<RepositoryModel> dataView = new DataView<RepositoryModel>("row", (IDataProvider)dp, (IDataProvider)dp, baseUrl){
            private static final long serialVersionUID = 1L;
            int counter;
            String currGroupName;
            final /* synthetic */ IDataProvider val$dp;
            final /* synthetic */ String val$baseUrl;
            {
                this.val$dp = iDataProvider;
                this.val$baseUrl = string;
                super(x0, x1);
            }

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<RepositoryModel> item) {
                boolean myPersonalRepository;
                UserModel ownerModel;
                Label swatch;
                final RepositoryModel entry = (RepositoryModel)item.getModelObject();
                if (entry instanceof GroupRepositoryModel) {
                    GroupRepositoryModel groupRow = (GroupRepositoryModel)entry;
                    this.currGroupName = entry.name;
                    Fragment row = new Fragment("rowContent", "groupRepositoryRow", (MarkupContainer)this);
                    item.add(new Component[]{row});
                    String name = groupRow.name;
                    if (name.charAt(0) == '~') {
                        String username = name.substring(1);
                        UserModel user2 = GitBlit.self().getUserModel(username);
                        row.add(new Component[]{new LinkPanel("groupName", null, (user2 == null ? username : user2.getDisplayName()) + " (" + groupRow.count + ")", UserPage.class, WicketUtils.newUsernameParameter(username))});
                        row.add(new Component[]{new Label("groupDescription", this.getString("gb.personalRepositories"))});
                    } else {
                        row.add(new Component[]{new LinkPanel("groupName", null, groupRow.toString(), ProjectPage.class, WicketUtils.newProjectParameter(entry.name))});
                        row.add(new Component[]{new Label("groupDescription", entry.description == null ? "" : entry.description)});
                    }
                    WicketUtils.setCssClass(item, "group");
                    this.counter = 0;
                    return;
                }
                Fragment row = new Fragment("rowContent", "repositoryRow", (MarkupContainer)this);
                item.add(new Component[]{row});
                String repoName = entry.toString();
                if (!StringUtils.isEmpty(this.currGroupName) && repoName.indexOf(47) > -1) {
                    repoName = repoName.substring(this.currGroupName.length() + 1);
                }
                if (entry.isBare) {
                    swatch = new Label("repositorySwatch", "&nbsp;").setEscapeModelStrings(false);
                } else {
                    swatch = new Label("repositorySwatch", "!");
                    WicketUtils.setHtmlTooltip((Component)swatch, this.getString("gb.workingCopyWarning"));
                }
                WicketUtils.setCssBackground((Component)swatch, entry.toString());
                row.add(new Component[]{swatch});
                swatch.setVisible(showSwatch);
                if (linksActive) {
                    Class linkPage = entry.hasCommits ? SummaryPage.class : EmptyRepositoryPage.class;
                    PageParameters pp = WicketUtils.newRepositoryParameter(entry.name);
                    row.add(new Component[]{new LinkPanel("repositoryName", "list", repoName, linkPage, pp)});
                    row.add(new Component[]{new LinkPanel("repositoryDescription", "list", entry.description, linkPage, pp)});
                } else {
                    row.add(new Component[]{new Label("repositoryName", repoName)});
                    row.add(new Component[]{new Label("repositoryDescription", entry.description)});
                }
                if (entry.hasCommits) {
                    row.add(new Component[]{new Label("repositorySize", entry.size).setVisible(showSize)});
                } else {
                    row.add(new Component[]{new Label("repositorySize", "<span class='empty'>(" + this.getString("gb.empty") + ")</span>").setEscapeModelStrings(false)});
                }
                if (entry.isFork()) {
                    row.add(new Component[]{WicketUtils.newImage("forkIcon", "commit_divide_16x16.png", this.getString("gb.isFork"))});
                } else {
                    row.add(new Component[]{WicketUtils.newClearPixel("forkIcon").setVisible(false)});
                }
                if (entry.useTickets) {
                    row.add(new Component[]{WicketUtils.newImage("ticketsIcon", "bug_16x16.png", this.getString("gb.tickets"))});
                } else {
                    row.add(new Component[]{WicketUtils.newBlankImage("ticketsIcon")});
                }
                if (entry.useDocs) {
                    row.add(new Component[]{WicketUtils.newImage("docsIcon", "book_16x16.png", this.getString("gb.docs"))});
                } else {
                    row.add(new Component[]{WicketUtils.newBlankImage("docsIcon")});
                }
                if (entry.isFrozen) {
                    row.add(new Component[]{WicketUtils.newImage("frozenIcon", "cold_16x16.png", this.getString("gb.isFrozen"))});
                } else {
                    row.add(new Component[]{WicketUtils.newClearPixel("frozenIcon").setVisible(false)});
                }
                if (entry.isFederated) {
                    row.add(new Component[]{WicketUtils.newImage("federatedIcon", "federated_16x16.png", this.getString("gb.isFederated"))});
                } else {
                    row.add(new Component[]{WicketUtils.newClearPixel("federatedIcon").setVisible(false)});
                }
                switch (entry.accessRestriction) {
                    case NONE: {
                        row.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon")});
                        break;
                    }
                    case PUSH: {
                        row.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_go_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                        break;
                    }
                    case CLONE: {
                        row.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "lock_pull_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                        break;
                    }
                    case VIEW: {
                        row.add(new Component[]{WicketUtils.newImage("accessRestrictionIcon", "shield_16x16.png", (String)accessRestrictionTranslations.get((Object)entry.accessRestriction))});
                        break;
                    }
                    default: {
                        row.add(new Component[]{WicketUtils.newBlankImage("accessRestrictionIcon")});
                    }
                }
                String owner = entry.owner;
                if (!StringUtils.isEmpty(owner) && (ownerModel = GitBlit.self().getUserModel(owner)) != null) {
                    owner = ownerModel.getDisplayName();
                }
                row.add(new Component[]{new Label("repositoryOwner", owner)});
                String lastChange = entry.lastChange.getTime() == 0L ? "--" : RepositoriesPanel.this.getTimeUtils().timeAgo(entry.lastChange);
                Label lastChangeLabel = new Label("repositoryLastChange", lastChange);
                row.add(new Component[]{lastChangeLabel});
                WicketUtils.setCssClass((Component)lastChangeLabel, RepositoriesPanel.this.getTimeUtils().timeAgoCss(entry.lastChange));
                boolean showOwner = user != null && entry.isOwner(user.username);
                boolean bl = myPersonalRepository = showOwner && entry.isUsersPersonalRepository(user.username);
                if (showAdmin || myPersonalRepository) {
                    Fragment repositoryLinks = new Fragment("repositoryLinks", "repositoryAdminLinks", (MarkupContainer)this);
                    repositoryLinks.add(new Component[]{new BookmarkablePageLink("editRepository", EditRepositoryPage.class, WicketUtils.newRepositoryParameter(entry.name))});
                    Link<Void> deleteLink = new Link<Void>("deleteRepository"){
                        private static final long serialVersionUID = 1L;

                        public void onClick() {
                            if (GitBlit.self().deleteRepositoryModel(entry)) {
                                if (val$dp instanceof SortableRepositoriesProvider) {
                                    this.info(MessageFormat.format(this.getString("gb.repositoryDeleted"), entry));
                                    ((SortableRepositoriesProvider)val$dp).remove(entry);
                                } else {
                                    this.setResponsePage(this.getPage().getClass(), this.getPage().getPageParameters());
                                }
                            } else {
                                this.error((Serializable)((Object)MessageFormat.format(this.getString("gb.repositoryDeleteFailed"), entry)));
                            }
                        }
                    };
                    deleteLink.add(new IBehavior[]{new BasePanel.JavascriptEventConfirmation("onclick", MessageFormat.format(this.getString("gb.deleteRepository"), entry))});
                    repositoryLinks.add(new Component[]{deleteLink});
                    row.add(new Component[]{repositoryLinks});
                } else if (showOwner) {
                    Fragment repositoryLinks = new Fragment("repositoryLinks", "repositoryOwnerLinks", (MarkupContainer)this);
                    repositoryLinks.add(new Component[]{new BookmarkablePageLink("editRepository", EditRepositoryPage.class, WicketUtils.newRepositoryParameter(entry.name))});
                    row.add(new Component[]{repositoryLinks});
                } else {
                    row.add(new Component[]{new Label("repositoryLinks")});
                }
                row.add(new Component[]{new ExternalLink("syndication", SyndicationServlet.asLink(this.val$baseUrl, entry.name, null, 0)).setVisible(linksActive)});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{dataView});
        if (dp instanceof SortableDataProvider) {
            SortableDataProvider sdp = dp;
            Fragment fragment = new Fragment("headerContent", "flatRepositoryHeader", (MarkupContainer)this);
            fragment.add(new Component[]{this.newSort("orderByRepository", SortBy.repository, sdp, dataView)});
            fragment.add(new Component[]{this.newSort("orderByDescription", SortBy.description, sdp, dataView)});
            fragment.add(new Component[]{this.newSort("orderByOwner", SortBy.owner, sdp, dataView)});
            fragment.add(new Component[]{this.newSort("orderByDate", SortBy.date, sdp, dataView)});
            this.add(new Component[]{fragment});
        } else {
            Fragment fragment = new Fragment("headerContent", "groupRepositoryHeader", (MarkupContainer)this);
            this.add(new Component[]{fragment});
        }
    }

    protected OrderByBorder newSort(String wicketId, SortBy field, SortableDataProvider<?> dp, DataView<?> dataView) {
        return new OrderByBorder(wicketId, field.name(), (ISortStateLocator)dp, (DataView)dataView){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ DataView val$dataView;
            {
                this.val$dataView = dataView;
                super(x0, x1, x2);
            }

            protected void onSortChanged() {
                this.val$dataView.setCurrentPage(0);
            }
        };
    }

    private static class SortableRepositoriesProvider
    extends SortableDataProvider<RepositoryModel> {
        private static final long serialVersionUID = 1L;
        private List<RepositoryModel> list;

        protected SortableRepositoriesProvider(List<RepositoryModel> list) {
            this.list = list;
            this.setSort(SortBy.date.name(), false);
        }

        public void remove(RepositoryModel model) {
            this.list.remove(model);
        }

        public int size() {
            if (this.list == null) {
                return 0;
            }
            return this.list.size();
        }

        public IModel<RepositoryModel> model(RepositoryModel header) {
            return new Model((Serializable)header);
        }

        public Iterator<RepositoryModel> iterator(int first, int count) {
            SortParam sp = this.getSort();
            String prop = sp.getProperty();
            final boolean asc = sp.isAscending();
            if (prop == null || prop.equals(SortBy.date.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        if (asc) {
                            return o1.lastChange.compareTo(o2.lastChange);
                        }
                        return o2.lastChange.compareTo(o1.lastChange);
                    }
                });
            } else if (prop.equals(SortBy.repository.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        if (asc) {
                            return o1.name.compareTo(o2.name);
                        }
                        return o2.name.compareTo(o1.name);
                    }
                });
            } else if (prop.equals(SortBy.owner.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        if (asc) {
                            return o1.owner.compareTo(o2.owner);
                        }
                        return o2.owner.compareTo(o1.owner);
                    }
                });
            } else if (prop.equals(SortBy.description.name())) {
                Collections.sort(this.list, new Comparator<RepositoryModel>(){

                    @Override
                    public int compare(RepositoryModel o1, RepositoryModel o2) {
                        if (asc) {
                            return o1.description.compareTo(o2.description);
                        }
                        return o2.description.compareTo(o1.description);
                    }
                });
            }
            return this.list.subList(first, first + count).iterator();
        }
    }

    private static class RepositoriesProvider
    extends ListDataProvider<RepositoryModel> {
        private static final long serialVersionUID = 1L;

        public RepositoriesProvider(List<RepositoryModel> list) {
            super(list);
        }

        public List<RepositoryModel> getData() {
            return super.getData();
        }

        public void remove(RepositoryModel model) {
            int index = this.getData().indexOf(model);
            RepositoryModel groupModel = null;
            if (index == this.getData().size() - 1) {
                if (index > 0 && this.getData().get(index - 1) instanceof GroupRepositoryModel) {
                    groupModel = this.getData().get(index - 1);
                }
            } else if (index < this.getData().size() - 1 && this.getData().get(index - 1) instanceof GroupRepositoryModel && this.getData().get(index + 1) instanceof GroupRepositoryModel) {
                groupModel = this.getData().get(index - 1);
            }
            if (groupModel == null) {
                for (int i = index; i >= 0; --i) {
                    if (!(this.getData().get(i) instanceof GroupRepositoryModel)) continue;
                    --((GroupRepositoryModel)this.getData().get((int)i)).count;
                    break;
                }
            } else {
                this.getData().remove(groupModel);
            }
            this.getData().remove(model);
        }
    }

    protected static enum SortBy {
        repository,
        description,
        owner,
        date;

    }

    private static class GroupRepositoryModel
    extends RepositoryModel {
        private static final long serialVersionUID = 1L;
        int count;
        String title;

        GroupRepositoryModel(String name, int count) {
            super(name, "", "", new Date(0L));
            this.count = count;
        }

        @Override
        public String toString() {
            return (StringUtils.isEmpty(this.title) ? this.name : this.title) + " (" + this.count + ")";
        }
    }
}

