/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class PagerPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public PagerPanel(String wicketId, final int currentPage, final int totalPages, final Class<? extends BasePage> pageClass, final PageParameters baseParams) {
        super(wicketId);
        ArrayList<PageObject> pages = new ArrayList<PageObject>();
        int[] deltas = currentPage == 1 ? new int[]{0, 1, 2, 3, 4} : (currentPage == 2 ? new int[]{-1, 0, 1, 2, 3} : new int[]{-2, -1, 0, 1, 2});
        if (totalPages > 0) {
            pages.add(new PageObject("\u2190", currentPage - 1));
        }
        for (int delta : deltas) {
            int page = currentPage + delta;
            if (page <= 0 || page > totalPages) continue;
            pages.add(new PageObject("" + page, page));
        }
        if (totalPages > 0) {
            pages.add(new PageObject("\u2192", currentPage + 1));
        }
        ListDataProvider pagesProvider = new ListDataProvider(pages);
        DataView<PageObject> pagesView = new DataView<PageObject>("page", (IDataProvider)pagesProvider){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<PageObject> item) {
                PageObject pageItem = (PageObject)item.getModelObject();
                PageParameters pageParams = new PageParameters((Map)baseParams);
                pageParams.put("pg", (Object)pageItem.page);
                LinkPanel link = new LinkPanel("pageLink", null, pageItem.text, (Class<? extends WebPage>)pageClass, pageParams);
                link.setRenderBodyOnly(true);
                item.add(new Component[]{link});
                if (pageItem.page == currentPage || pageItem.page < 1 || pageItem.page > totalPages) {
                    WicketUtils.setCssClass(item, "disabled");
                }
            }
        };
        this.add(new Component[]{pagesView});
    }

    private class PageObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String text;
        int page;

        PageObject(String text, int page) {
            this.text = text;
            this.page = page;
        }
    }
}

