/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.GitBlit;
import com.gitblit.utils.ActivityUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.ExternalImage;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.GravatarProfilePage;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.eclipse.jgit.lib.PersonIdent;

public class GravatarImage
extends Panel {
    private static final long serialVersionUID = 1L;

    public GravatarImage(String id, PersonIdent person) {
        this(id, person, 0);
    }

    public GravatarImage(String id, PersonIdent person, int width) {
        this(id, person, width, true);
    }

    public GravatarImage(String id, PersonIdent person, int width, boolean linked) {
        super(id);
        String email = person.getEmailAddress() == null ? person.getName().toLowerCase() : person.getEmailAddress().toLowerCase();
        String hash = StringUtils.getMD5(email);
        BookmarkablePageLink link = new BookmarkablePageLink("link", GravatarProfilePage.class, WicketUtils.newObjectParameter(hash));
        link.add(new IBehavior[]{new SimpleAttributeModifier("target", (CharSequence)"_blank")});
        String url = ActivityUtils.getGravatarThumbnailUrl(email, width);
        ExternalImage image = new ExternalImage("image", url);
        WicketUtils.setCssClass((Component)image, "gravatar");
        link.add(new Component[]{image});
        if (linked) {
            WicketUtils.setHtmlTooltip((Component)link, MessageFormat.format("View Gravatar profile for {0}", person.getName()));
        } else {
            WicketUtils.setHtmlTooltip((Component)link, person.getName());
        }
        this.add(new Component[]{link.setEnabled(linked)});
        this.setVisible(GitBlit.getBoolean("web.allowGravatar", true));
    }
}

