/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.GitBlit;
import com.gitblit.models.FederationModel;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.FederationRegistrationPage;
import com.gitblit.wicket.panels.BasePanel;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class FederationRegistrationsPanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private final boolean hasRegistrations;

    public FederationRegistrationsPanel(String wicketId) {
        super(wicketId);
        ArrayList<FederationModel> list = new ArrayList<FederationModel>(GitBlit.self().getFederationRegistrations());
        list.addAll(GitBlit.self().getFederationResultRegistrations());
        Collections.sort(list);
        this.hasRegistrations = list.size() > 0;
        DataView<FederationModel> dataView = new DataView<FederationModel>("row", (IDataProvider)new ListDataProvider(list)){
            private static final long serialVersionUID = 1L;
            private int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<FederationModel> item) {
                FederationModel entry = (FederationModel)item.getModelObject();
                item.add(new Component[]{new LinkPanel("url", "list", entry.url, FederationRegistrationPage.class, WicketUtils.newRegistrationParameter(entry.url, entry.name))});
                item.add(new Component[]{WicketUtils.getPullStatusImage("statusIcon", entry.getLowestStatus())});
                item.add(new Component[]{new LinkPanel("name", "list", entry.name, FederationRegistrationPage.class, WicketUtils.newRegistrationParameter(entry.url, entry.name))});
                item.add(new Component[]{WicketUtils.getRegistrationImage("typeIcon", entry, (Component)this)});
                item.add(new Component[]{WicketUtils.createDateLabel("lastPull", entry.lastPull, FederationRegistrationsPanel.this.getTimeZone(), FederationRegistrationsPanel.this.getTimeUtils())});
                item.add(new Component[]{WicketUtils.createTimestampLabel("nextPull", entry.nextPull, FederationRegistrationsPanel.this.getTimeZone(), FederationRegistrationsPanel.this.getTimeUtils())});
                item.add(new Component[]{new Label("frequency", entry.frequency)});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{dataView});
    }

    public Component hideIfEmpty() {
        return super.setVisible(this.hasRegistrations);
    }
}

