/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.panels.LinkPanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class DropDownMenu
extends Panel {
    private static final long serialVersionUID = 1L;

    public DropDownMenu(String id, String label, final PageRegistration.DropDownMenuRegistration menu) {
        super(id);
        this.add(new Component[]{new Label("label", label).setRenderBodyOnly(true)});
        ListDataProvider items = new ListDataProvider(menu.menuItems);
        DataView<PageRegistration.DropDownMenuItem> view = new DataView<PageRegistration.DropDownMenuItem>("menuItems", (IDataProvider)items){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<PageRegistration.DropDownMenuItem> item) {
                PageRegistration.DropDownMenuItem entry = (PageRegistration.DropDownMenuItem)item.getModelObject();
                if (entry.isDivider()) {
                    item.add(new Component[]{new Label("menuItem").setRenderBodyOnly(true)});
                    WicketUtils.setCssClass(item, "divider");
                } else {
                    String icon = null;
                    icon = entry.isSelected() ? "icon-ok" : "icon-ok-white";
                    item.add(new Component[]{new LinkPanel("menuItem", icon, null, entry.toString(), (Class<? extends WebPage>)menu.pageClass, entry.getPageParameters(), false).setRenderBodyOnly(true)});
                }
            }
        };
        this.add(new Component[]{view});
        this.setRenderBodyOnly(true);
    }
}

