/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.panels;

import com.gitblit.models.PathModel;
import com.gitblit.wicket.WicketUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.diff.DiffEntry;

public class CommitLegendPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public CommitLegendPanel(String id, List<PathModel.PathChangeModel> paths) {
        super(id);
        final Map<DiffEntry.ChangeType, AtomicInteger> stats = this.getChangedPathsStats(paths);
        ListDataProvider legendDp = new ListDataProvider(new ArrayList<DiffEntry.ChangeType>(stats.keySet()));
        DataView<DiffEntry.ChangeType> legendsView = new DataView<DiffEntry.ChangeType>("legend", (IDataProvider)legendDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<DiffEntry.ChangeType> item) {
                DiffEntry.ChangeType entry = (DiffEntry.ChangeType)item.getModelObject();
                Label changeType = new Label("changeType", "");
                WicketUtils.setChangeTypeCssClass((Component)changeType, entry);
                item.add(new Component[]{changeType});
                int count = ((AtomicInteger)stats.get(entry)).intValue();
                String description = "";
                switch (entry) {
                    case ADD: {
                        description = MessageFormat.format(this.getString("gb.filesAdded"), count);
                        break;
                    }
                    case MODIFY: {
                        description = MessageFormat.format(this.getString("gb.filesModified"), count);
                        break;
                    }
                    case DELETE: {
                        description = MessageFormat.format(this.getString("gb.filesDeleted"), count);
                        break;
                    }
                    case COPY: {
                        description = MessageFormat.format(this.getString("gb.filesCopied"), count);
                        break;
                    }
                    case RENAME: {
                        description = MessageFormat.format(this.getString("gb.filesRenamed"), count);
                    }
                }
                item.add(new Component[]{new Label("description", description)});
            }
        };
        this.add(new Component[]{legendsView});
    }

    protected Map<DiffEntry.ChangeType, AtomicInteger> getChangedPathsStats(List<PathModel.PathChangeModel> paths) {
        HashMap<DiffEntry.ChangeType, AtomicInteger> stats = new HashMap<DiffEntry.ChangeType, AtomicInteger>();
        for (PathModel.PathChangeModel path : paths) {
            if (!stats.containsKey(path.changeType)) {
                stats.put(path.changeType, new AtomicInteger(0));
            }
            ((AtomicInteger)stats.get(path.changeType)).incrementAndGet();
        }
        return stats;
    }
}

