/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebApp;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.EditRepositoryPage;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.panels.GravatarImage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.ProjectRepositoryPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.PersonIdent;

public class UserPage
extends RootPage {
    List<ProjectModel> projectModels = new ArrayList<ProjectModel>();

    public UserPage() {
        throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
    }

    public UserPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    private void setup(PageParameters params) {
        this.setupPage("", "");
        boolean authenticateView = GitBlit.getBoolean("web.authenticateViewPages", true);
        if (authenticateView && !GitBlitWebSession.get().isLoggedIn()) {
            this.authenticationError("Please login");
            return;
        }
        String userName = WicketUtils.getUsername(params);
        if (StringUtils.isEmpty(userName)) {
            throw new GitblitRedirectException(GitBlitWebApp.get().getHomePage());
        }
        UserModel user = GitBlit.self().getUserModel(userName);
        if (user == null) {
            user = new UserModel(userName);
        }
        String projectName = "~" + userName;
        ProjectModel project = GitBlit.self().getProjectModel(projectName);
        if (project == null) {
            project = new ProjectModel(projectName);
        }
        this.add(new Component[]{new Label("userDisplayName", user.getDisplayName())});
        this.add(new Component[]{new Label("userUsername", user.username)});
        LinkPanel email = new LinkPanel("userEmail", null, user.emailAddress, "mailto:#");
        email.setRenderBodyOnly(true);
        this.add(new Component[]{email.setVisible(GitBlit.getBoolean("web.showEmailAddresses", true) && !StringUtils.isEmpty(user.emailAddress))});
        PersonIdent person = new PersonIdent(user.getDisplayName(), user.emailAddress == null ? user.getDisplayName() : user.emailAddress);
        this.add(new Component[]{new GravatarImage("gravatar", person, 210)});
        UserModel sessionUser = GitBlitWebSession.get().getUser();
        if (sessionUser != null && user.canCreate() && sessionUser.equals(user)) {
            this.add(new Component[]{new BookmarkablePageLink("newRepository", EditRepositoryPage.class)});
        } else {
            this.add(new Component[]{new Label("newRepository").setVisible(false)});
        }
        List<RepositoryModel> repositories = this.getRepositories(params);
        Collections.sort(repositories, new Comparator<RepositoryModel>(){

            @Override
            public int compare(RepositoryModel o1, RepositoryModel o2) {
                return o2.lastChange.compareTo(o1.lastChange);
            }
        });
        ListDataProvider dp = new ListDataProvider(repositories);
        DataView<RepositoryModel> dataView = new DataView<RepositoryModel>("repositoryList", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<RepositoryModel> item) {
                RepositoryModel entry = (RepositoryModel)item.getModelObject();
                ProjectRepositoryPanel row = new ProjectRepositoryPanel("repository", this.getLocalizer(), (Component)this, UserPage.this.showAdmin, entry, UserPage.this.getAccessRestrictions());
                item.add(new Component[]{row});
            }
        };
        this.add(new Component[]{dataView});
    }

    @Override
    protected void addDropDownMenus(List<PageRegistration> pages) {
        PageParameters params = this.getPageParameters();
        PageRegistration.DropDownMenuRegistration menu = new PageRegistration.DropDownMenuRegistration("gb.filters", UserPage.class);
        menu.menuItems.addAll(this.getRepositoryFilterItems(params));
        menu.menuItems.addAll(this.getTimeFilterItems(params));
        if (menu.menuItems.size() > 0) {
            menu.menuItems.add(new PageRegistration.DropDownMenuItem(this.getString("gb.reset"), null, null));
        }
        pages.add(menu);
    }
}

