/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.TicketModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TicgitUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TicketPage;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;

public class TicketsPage
extends RepositoryPage {
    public TicketsPage(PageParameters params) {
        super(params);
        List<TicketModel> tickets = TicgitUtils.getTickets(this.getRepository());
        this.add(new Component[]{new LinkPanel("header", "title", this.repositoryName, SummaryPage.class, this.newRepositoryParameter())});
        ListDataProvider ticketsDp = new ListDataProvider(tickets);
        DataView<TicketModel> ticketsView = new DataView<TicketModel>("ticket", (IDataProvider)ticketsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<TicketModel> item) {
                TicketModel entry = (TicketModel)item.getModelObject();
                Label stateLabel = new Label("ticketState", entry.state);
                WicketUtils.setTicketCssClass((Component)stateLabel, entry.state);
                item.add(new Component[]{stateLabel});
                item.add(new Component[]{WicketUtils.createDateLabel("ticketDate", entry.date, GitBlitWebSession.get().getTimezone(), TicketsPage.this.getTimeUtils())});
                item.add(new Component[]{new Label("ticketHandler", StringUtils.trimString(entry.handler.toLowerCase(), 30))});
                item.add(new Component[]{new LinkPanel("ticketTitle", "list subject", StringUtils.trimString(entry.title, 80), TicketPage.class, TicketsPage.this.newPathParameter(entry.name))});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{ticketsView});
    }

    protected PageParameters newPathParameter(String path) {
        return WicketUtils.newPathParameter(this.repositoryName, this.objectId, path);
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.tickets");
    }
}

