/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.FederationProposal;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.RequiresAdminRole;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RootSubPage;
import com.gitblit.wicket.panels.RepositoriesPanel;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;

@RequiresAdminRole
public class ReviewProposalPage
extends RootSubPage {
    private final String PROPS_PATTERN = "{0} = {1}\n";
    private final String WEBXML_PATTERN = "\n<context-param>\n\t<param-name>{0}</param-name>\n\t<param-value>{1}</param-value>\n</context-param>\n";

    public ReviewProposalPage(PageParameters params) {
        super(params);
        String token = WicketUtils.getToken(params);
        FederationProposal proposal = GitBlit.self().getPendingFederationProposal(token);
        if (proposal == null) {
            this.error(this.getString("gb.couldNotFindFederationProposal"), true);
        }
        this.setupPage(this.getString("gb.proposals"), proposal.url);
        this.add(new Component[]{new Label("url", proposal.url)});
        this.add(new Component[]{new Label("message", proposal.message)});
        this.add(new Component[]{WicketUtils.createTimestampLabel("received", proposal.received, this.getTimeZone(), this.getTimeUtils())});
        this.add(new Component[]{new Label("token", proposal.token)});
        this.add(new Component[]{new Label("tokenType", proposal.tokenType.name())});
        String p = GitBlit.isGO() ? "{0} = {1}\n" : "\n<context-param>\n\t<param-name>{0}</param-name>\n\t<param-value>{1}</param-value>\n</context-param>\n";
        StringBuilder sb = new StringBuilder();
        sb.append(this.asParam(p, proposal.name, "url", proposal.url));
        sb.append(this.asParam(p, proposal.name, "token", proposal.token));
        if (Constants.FederationToken.USERS_AND_REPOSITORIES.equals((Object)proposal.tokenType) || Constants.FederationToken.ALL.equals((Object)proposal.tokenType)) {
            sb.append(this.asParam(p, proposal.name, "mergeAccounts", "false"));
        }
        sb.append(this.asParam(p, proposal.name, "frequency", GitBlit.getString("federation.defaultFrequency", "60 mins")));
        sb.append(this.asParam(p, proposal.name, "folder", proposal.name));
        sb.append(this.asParam(p, proposal.name, "bare", "true"));
        sb.append(this.asParam(p, proposal.name, "mirror", "true"));
        sb.append(this.asParam(p, proposal.name, "sendStatus", "true"));
        sb.append(this.asParam(p, proposal.name, "notifyOnError", "true"));
        sb.append(this.asParam(p, proposal.name, "exclude", ""));
        sb.append(this.asParam(p, proposal.name, "include", ""));
        this.add(new Component[]{new Label("definition", StringUtils.breakLinesForHtml(StringUtils.escapeForHtml(sb.toString().trim(), true))).setEscapeModelStrings(false)});
        ArrayList<RepositoryModel> repositories = new ArrayList<RepositoryModel>(proposal.repositories.values());
        RepositoriesPanel repositoriesPanel = new RepositoriesPanel("repositoriesPanel", false, false, repositories, false, this.getAccessRestrictions());
        this.add(new Component[]{repositoriesPanel});
    }

    private String asParam(String pattern, String name, String key, String value) {
        return MessageFormat.format(pattern, "federation." + name + "." + key, value);
    }
}

