/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.PagesServlet;
import com.gitblit.SyndicationServlet;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.TicgitUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.SessionlessForm;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BasePage;
import com.gitblit.wicket.pages.BranchesPage;
import com.gitblit.wicket.pages.DocsPage;
import com.gitblit.wicket.pages.EditRepositoryPage;
import com.gitblit.wicket.pages.EmptyRepositoryPage;
import com.gitblit.wicket.pages.ForkPage;
import com.gitblit.wicket.pages.ForksPage;
import com.gitblit.wicket.pages.GitSearchPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.LuceneSearchPage;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.RepositoriesPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TagsPage;
import com.gitblit.wicket.pages.TicketsPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.NavigationPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageParameters;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.request.target.basic.RedirectRequestTarget;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public abstract class RepositoryPage
extends BasePage {
    protected final String projectName;
    protected final String repositoryName;
    protected final String objectId;
    private transient Repository r;
    private RepositoryModel m;
    private Map<String, SubmoduleModel> submodules;
    private final Map<String, PageRegistration> registeredPages;
    private boolean showAdmin;
    private boolean isOwner;

    public RepositoryPage(PageParameters params) {
        super(params);
        this.repositoryName = WicketUtils.getRepositoryName(params);
        String root = StringUtils.getFirstPathElement(this.repositoryName);
        this.projectName = StringUtils.isEmpty(root) ? GitBlit.getString("web.repositoryRootGroupName", "main") : root;
        this.objectId = WicketUtils.getObject(params);
        if (StringUtils.isEmpty(this.repositoryName)) {
            this.error(MessageFormat.format(this.getString("gb.repositoryNotSpecifiedFor"), this.getPageName()), true);
        }
        if (!this.getRepositoryModel().hasCommits) {
            this.setResponsePage(EmptyRepositoryPage.class, params);
        }
        if (this.getRepositoryModel().isCollectingGarbage) {
            this.error(MessageFormat.format(this.getString("gb.busyCollectingGarbage"), this.getRepositoryModel().name), true);
        }
        if (this.objectId != null) {
            RefModel branch = null;
            branch = JGitUtils.getBranch(this.getRepository(), this.objectId);
            if (branch != null) {
                boolean canAccess;
                UserModel user = GitBlitWebSession.get().getUser();
                if (user == null) {
                    user = UserModel.ANONYMOUS;
                }
                if (!(canAccess = user.canView(this.getRepositoryModel(), branch.reference.getName()))) {
                    this.error(this.getString("gb.accessDenied"), true);
                }
            }
        }
        this.registeredPages = this.registerPages();
        ArrayList<PageRegistration> pages = new ArrayList<PageRegistration>(this.registeredPages.values());
        NavigationPanel navigationPanel = new NavigationPanel("navPanel", ((Object)((Object)this)).getClass(), pages);
        this.add(new Component[]{navigationPanel});
        this.add(new Component[]{new ExternalLink("syndication", SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), this.repositoryName, null, 0))});
        SearchForm searchForm = new SearchForm("searchForm", this.repositoryName);
        this.add(new Component[]{searchForm});
        searchForm.setTranslatedAttributes();
        this.setStatelessHint(true);
    }

    private Map<String, PageRegistration> registerPages() {
        boolean allowAdmin;
        PageParameters params = null;
        if (!StringUtils.isEmpty(this.repositoryName)) {
            params = WicketUtils.newRepositoryParameter(this.repositoryName);
        }
        LinkedHashMap<String, PageRegistration> pages = new LinkedHashMap<String, PageRegistration>();
        pages.put("repositories", new PageRegistration("gb.repositories", RepositoriesPage.class));
        pages.put("summary", new PageRegistration("gb.summary", SummaryPage.class, params));
        pages.put("log", new PageRegistration("gb.log", LogPage.class, params));
        pages.put("branches", new PageRegistration("gb.branches", BranchesPage.class, params));
        pages.put("tags", new PageRegistration("gb.tags", TagsPage.class, params));
        pages.put("tree", new PageRegistration("gb.tree", TreePage.class, params));
        if (GitBlit.getBoolean("web.allowForking", true)) {
            pages.put("forks", new PageRegistration("gb.forks", ForksPage.class, params));
        }
        Repository r = this.getRepository();
        RepositoryModel model = this.getRepositoryModel();
        if (model.useTickets && TicgitUtils.getTicketsBranch(r) != null) {
            pages.put("tickets", new PageRegistration("gb.tickets", TicketsPage.class, params));
        }
        if (model.useDocs) {
            pages.put("docs", new PageRegistration("gb.docs", DocsPage.class, params));
        }
        if (JGitUtils.getPagesBranch(r) != null) {
            PageRegistration.OtherPageLink pagesLink = new PageRegistration.OtherPageLink("gb.pages", PagesServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), this.repositoryName, null));
            pages.put("pages", pagesLink);
        }
        this.showAdmin = false;
        this.showAdmin = GitBlit.getBoolean("web.authenticateAdminPages", true) ? (allowAdmin = GitBlit.getBoolean("web.allowAdministration", false)) && GitBlitWebSession.get().canAdmin() : GitBlit.getBoolean("web.allowAdministration", false);
        boolean bl = this.isOwner = GitBlitWebSession.get().isLoggedIn() && model.owner != null && model.owner.equalsIgnoreCase(GitBlitWebSession.get().getUsername());
        if (this.showAdmin || this.isOwner) {
            pages.put("edit", new PageRegistration("gb.edit", EditRepositoryPage.class, params));
        }
        return pages;
    }

    protected boolean allowForkControls() {
        return GitBlit.getBoolean("web.allowForking", true);
    }

    @Override
    protected void setupPage(String repositoryName, String pageName) {
        String projectName = StringUtils.getFirstPathElement(repositoryName);
        ProjectModel project = GitBlit.self().getProjectModel(projectName);
        if (project.isUserProject()) {
            this.add(new Component[]{new LinkPanel("projectTitle", null, project.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(project.name.substring(1)))});
        } else {
            this.add(new Component[]{new LinkPanel("projectTitle", null, project.name, ProjectPage.class, WicketUtils.newProjectParameter(project.name))});
        }
        String name = StringUtils.stripDotGit(repositoryName);
        if (!StringUtils.isEmpty(projectName) && name.startsWith(projectName)) {
            name = name.substring(projectName.length() + 1);
        }
        this.add(new Component[]{new LinkPanel("repositoryName", null, name, SummaryPage.class, WicketUtils.newRepositoryParameter(repositoryName))});
        this.add(new Component[]{new Label("pageName", pageName).setRenderBodyOnly(true)});
        UserModel user = GitBlitWebSession.get().getUser();
        if (user == null) {
            user = UserModel.ANONYMOUS;
        }
        RepositoryModel model = this.getRepositoryModel();
        if (StringUtils.isEmpty(model.originRepository)) {
            this.add(new Component[]{new Label("originRepository").setVisible(false)});
        } else {
            Fragment forkFrag;
            RepositoryModel origin = GitBlit.self().getRepositoryModel(model.originRepository);
            if (origin == null) {
                this.add(new Component[]{new Label("originRepository").setVisible(false)});
            } else if (!user.canView(origin)) {
                forkFrag = new Fragment("originRepository", "originFragment", (MarkupContainer)this);
                forkFrag.add(new Component[]{new Label("originRepository", StringUtils.stripDotGit(model.originRepository))});
                this.add(new Component[]{forkFrag});
            } else {
                forkFrag = new Fragment("originRepository", "originFragment", (MarkupContainer)this);
                forkFrag.add(new Component[]{new LinkPanel("originRepository", null, StringUtils.stripDotGit(model.originRepository), SummaryPage.class, WicketUtils.newRepositoryParameter(model.originRepository))});
                this.add(new Component[]{forkFrag});
            }
        }
        if (this.getRepositoryModel().isBare) {
            this.add(new Component[]{new Label("workingCopyIndicator").setVisible(false)});
        } else {
            Fragment wc = new Fragment("workingCopyIndicator", "workingCopyFragment", (MarkupContainer)this);
            Label lbl = new Label("workingCopy", this.getString("gb.workingCopy"));
            WicketUtils.setHtmlTooltip((Component)lbl, this.getString("gb.workingCopyWarning"));
            wc.add(new Component[]{lbl});
            this.add(new Component[]{wc});
        }
        if (!this.allowForkControls() || user == null || !user.isAuthenticated) {
            this.add(new Component[]{new ExternalLink("forkLink", "").setVisible(false)});
            this.add(new Component[]{new ExternalLink("myForkLink", "").setVisible(false)});
            this.add(new Component[]{new Label("forksProhibitedIndicator").setVisible(false)});
        } else {
            String fork = GitBlit.self().getFork(user.username, model.name);
            boolean hasFork = fork != null;
            boolean canFork = user.canFork(model);
            if (hasFork || !canFork) {
                this.add(new Component[]{new ExternalLink("forkLink", "").setVisible(false)});
                if (user.canFork() && !model.allowForks) {
                    Fragment wc = new Fragment("forksProhibitedIndicator", "forksProhibitedFragment", (MarkupContainer)this);
                    Label lbl = new Label("forksProhibited", this.getString("gb.forksProhibited"));
                    WicketUtils.setHtmlTooltip((Component)lbl, this.getString("gb.forksProhibitedWarning"));
                    wc.add(new Component[]{lbl});
                    this.add(new Component[]{wc});
                } else {
                    this.add(new Component[]{new Label("forksProhibitedIndicator").setVisible(false)});
                }
                if (hasFork && !fork.equals(model.name)) {
                    String url = ((Object)this.getRequestCycle().urlFor(SummaryPage.class, WicketUtils.newRepositoryParameter(fork))).toString();
                    this.add(new Component[]{new ExternalLink("myForkLink", url)});
                } else {
                    this.add(new Component[]{new ExternalLink("myForkLink", "").setVisible(false)});
                }
            } else if (canFork) {
                this.add(new Component[]{new Label("forksProhibitedIndicator").setVisible(false)});
                this.add(new Component[]{new ExternalLink("myForkLink", "").setVisible(false)});
                String url = ((Object)this.getRequestCycle().urlFor(ForkPage.class, WicketUtils.newRepositoryParameter(model.name))).toString();
                this.add(new Component[]{new ExternalLink("forkLink", url)});
            }
        }
        super.setupPage(repositoryName, pageName);
    }

    protected void addSyndicationDiscoveryLink() {
        this.add(new IBehavior[]{WicketUtils.syndicationDiscoveryLink(SyndicationServlet.getTitle(this.repositoryName, this.objectId), SyndicationServlet.asLink(this.getRequest().getRelativePathPrefixToContextRoot(), this.repositoryName, this.objectId, 0))});
    }

    protected Repository getRepository() {
        if (this.r == null) {
            Repository r = GitBlit.self().getRepository(this.repositoryName);
            if (r == null) {
                this.error(this.getString("gb.canNotLoadRepository") + " " + this.repositoryName, true);
                return null;
            }
            this.r = r;
        }
        return this.r;
    }

    protected RepositoryModel getRepositoryModel() {
        if (this.m == null) {
            RepositoryModel model = GitBlit.self().getRepositoryModel(GitBlitWebSession.get().getUser(), this.repositoryName);
            if (model == null) {
                if (GitBlit.self().hasRepository(this.repositoryName, true)) {
                    this.authenticationError(this.getString("gb.unauthorizedAccessForRepository") + " " + this.repositoryName);
                } else {
                    this.error(this.getString("gb.canNotLoadRepository") + " " + this.repositoryName, true);
                }
                return null;
            }
            this.m = model;
        }
        return this.m;
    }

    protected RevCommit getCommit() {
        RevCommit commit = JGitUtils.getCommit(this.r, this.objectId);
        if (commit == null) {
            this.error(MessageFormat.format(this.getString("gb.failedToFindCommit"), this.objectId, this.repositoryName, this.getPageName()), true);
        }
        this.getSubmodules(commit);
        return commit;
    }

    private Map<String, SubmoduleModel> getSubmodules(RevCommit commit) {
        if (this.submodules == null) {
            this.submodules = new HashMap<String, SubmoduleModel>();
            for (SubmoduleModel model : JGitUtils.getSubmodules(this.r, commit.getTree())) {
                this.submodules.put(model.path, model);
            }
        }
        return this.submodules;
    }

    protected Map<String, SubmoduleModel> getSubmodules() {
        return this.submodules;
    }

    protected SubmoduleModel getSubmodule(String path) {
        String name;
        SubmoduleModel model = this.submodules.get(path);
        if (model == null) {
            model = new SubmoduleModel(path.substring(path.lastIndexOf(47) + 1), path, path);
            model.hasSubmodule = false;
            model.gitblitPath = model.name;
            return model;
        }
        List<String> patterns = GitBlit.getStrings("git.submoduleUrlPatterns");
        String submoduleName = StringUtils.extractRepositoryPath(model.url, patterns.toArray(new String[0]));
        String currentPath = "";
        if (this.repositoryName.indexOf(47) > -1) {
            currentPath = this.repositoryName.substring(0, this.repositoryName.lastIndexOf(47) + 1);
        }
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(currentPath + StringUtils.stripDotGit(submoduleName));
        candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        if (submoduleName.lastIndexOf(47) > -1) {
            name = submoduleName.substring(submoduleName.lastIndexOf(47) + 1);
            candidates.add(currentPath + StringUtils.stripDotGit(name));
            candidates.add(currentPath + (String)candidates.get(candidates.size() - 1) + ".git");
        }
        candidates.add(StringUtils.stripDotGit(submoduleName));
        candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        if (submoduleName.lastIndexOf(47) > -1) {
            name = submoduleName.substring(submoduleName.lastIndexOf(47) + 1);
            candidates.add(StringUtils.stripDotGit(name));
            candidates.add((String)candidates.get(candidates.size() - 1) + ".git");
        }
        LinkedHashSet paths = new LinkedHashSet(candidates);
        for (String candidate : paths) {
            if (!GitBlit.self().hasRepository(candidate)) continue;
            model.hasSubmodule = true;
            model.gitblitPath = candidate;
            return model;
        }
        model.gitblitPath = (String)candidates.get(0);
        return model;
    }

    protected String getShortObjectId(String objectId) {
        return objectId.substring(0, GitBlit.getInteger("web.shortCommitIdLength", 6));
    }

    protected void addRefs(Repository r, RevCommit c) {
        this.add(new Component[]{new RefsPanel("refsPanel", this.repositoryName, c, JGitUtils.getAllRefs(r, this.getRepositoryModel().showRemoteBranches))});
    }

    protected void addFullText(String wicketId, String text, boolean substituteRegex) {
        String html = StringUtils.escapeForHtml(text, true);
        html = substituteRegex ? GitBlit.self().processCommitMessage(this.repositoryName, text) : StringUtils.breakLinesForHtml(html);
        this.add(new Component[]{new Label(wicketId, html).setEscapeModelStrings(false)});
    }

    protected abstract String getPageName();

    protected Component createPersonPanel(String wicketId, PersonIdent identity, Constants.SearchType searchType) {
        String name = identity == null ? "" : identity.getName();
        String address = identity == null ? "" : identity.getEmailAddress();
        name = StringUtils.removeNewlines(name);
        address = StringUtils.removeNewlines(address);
        boolean showEmail = GitBlit.getBoolean("web.showEmailAddresses", false);
        if (!showEmail || StringUtils.isEmpty(name) || StringUtils.isEmpty(address)) {
            String value = name;
            if (StringUtils.isEmpty(value)) {
                value = showEmail ? address : this.getString("gb.missingUsername");
            }
            Fragment partial = new Fragment(wicketId, "partialPersonIdent", (MarkupContainer)this);
            LinkPanel link = new LinkPanel("personName", "list", value, GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, value, searchType));
            this.setPersonSearchTooltip((Component)link, value, searchType);
            partial.add(new Component[]{link});
            return partial;
        }
        Fragment fullPerson = new Fragment(wicketId, "fullPersonIdent", (MarkupContainer)this);
        LinkPanel nameLink = new LinkPanel("personName", "list", name, GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, name, searchType));
        this.setPersonSearchTooltip((Component)nameLink, name, searchType);
        fullPerson.add(new Component[]{nameLink});
        LinkPanel addressLink = new LinkPanel("personAddress", "hidden-phone list", "<" + address + ">", GitSearchPage.class, WicketUtils.newSearchParameter(this.repositoryName, this.objectId, address, searchType));
        this.setPersonSearchTooltip((Component)addressLink, address, searchType);
        fullPerson.add(new Component[]{addressLink});
        return fullPerson;
    }

    protected void setPersonSearchTooltip(Component component, String value, Constants.SearchType searchType) {
        if (searchType.equals((Object)Constants.SearchType.AUTHOR)) {
            WicketUtils.setHtmlTooltip(component, this.getString("gb.searchForAuthor") + " " + value);
        } else if (searchType.equals((Object)Constants.SearchType.COMMITTER)) {
            WicketUtils.setHtmlTooltip(component, this.getString("gb.searchForCommitter") + " " + value);
        }
    }

    protected void setChangeTypeTooltip(Component container, DiffEntry.ChangeType type) {
        switch (type) {
            case ADD: {
                WicketUtils.setHtmlTooltip(container, this.getString("gb.addition"));
                break;
            }
            case COPY: 
            case RENAME: {
                WicketUtils.setHtmlTooltip(container, this.getString("gb.rename"));
                break;
            }
            case DELETE: {
                WicketUtils.setHtmlTooltip(container, this.getString("gb.deletion"));
                break;
            }
            case MODIFY: {
                WicketUtils.setHtmlTooltip(container, this.getString("gb.modification"));
            }
        }
    }

    @Override
    protected void onBeforeRender() {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
        this.setupPage(this.repositoryName, "/ " + this.getPageName());
        super.onBeforeRender();
    }

    protected PageParameters newRepositoryParameter() {
        return WicketUtils.newRepositoryParameter(this.repositoryName);
    }

    protected PageParameters newCommitParameter() {
        return WicketUtils.newObjectParameter(this.repositoryName, this.objectId);
    }

    protected PageParameters newCommitParameter(String commitId) {
        return WicketUtils.newObjectParameter(this.repositoryName, commitId);
    }

    public boolean isShowAdmin() {
        return this.showAdmin;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    private class SearchForm
    extends SessionlessForm<Void>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String repositoryName;
        private final IModel<String> searchBoxModel;
        private final IModel<Constants.SearchType> searchTypeModel;

        public SearchForm(String id, String repositoryName) {
            super(id, ((Object)((Object)RepositoryPage.this)).getClass(), RepositoryPage.this.getPageParameters());
            this.searchBoxModel = new Model((Serializable)((Object)""));
            this.searchTypeModel = new Model((Serializable)((Object)Constants.SearchType.COMMIT));
            this.repositoryName = repositoryName;
            DropDownChoice searchType = new DropDownChoice("searchType", Arrays.asList(Constants.SearchType.values()));
            searchType.setModel(this.searchTypeModel);
            this.add(new Component[]{searchType.setVisible(GitBlit.getBoolean("web.showSearchTypeSelection", false))});
            TextField searchBox = new TextField("searchBox", this.searchBoxModel);
            this.add(new Component[]{searchBox});
        }

        void setTranslatedAttributes() {
            WicketUtils.setHtmlTooltip(this.get("searchType"), this.getString("gb.searchTypeTooltip"));
            WicketUtils.setHtmlTooltip(this.get("searchBox"), MessageFormat.format(this.getString("gb.searchTooltip"), this.repositoryName));
            WicketUtils.setInputPlaceholder(this.get("searchBox"), this.getString("gb.search"));
        }

        public void onSubmit() {
            Constants.SearchType searchType = (Constants.SearchType)((Object)this.searchTypeModel.getObject());
            String searchString = (String)this.searchBoxModel.getObject();
            if (searchString == null) {
                return;
            }
            for (Constants.SearchType type : Constants.SearchType.values()) {
                if (!searchString.toLowerCase().startsWith(type.name().toLowerCase() + ":")) continue;
                searchType = type;
                searchString = searchString.substring(type.name().toLowerCase().length() + 1).trim();
                break;
            }
            Class searchPageClass = GitSearchPage.class;
            RepositoryModel model = GitBlit.self().getRepositoryModel(this.repositoryName);
            if (GitBlit.getBoolean("web.allowLuceneIndexing", true) && !ArrayUtils.isEmpty(model.indexedBranches)) {
                searchPageClass = LuceneSearchPage.class;
            }
            PageParameters params = WicketUtils.newSearchParameter(this.repositoryName, null, searchString, searchType);
            String relativeUrl = ((Object)this.urlFor(searchPageClass, params)).toString();
            String absoluteUrl = RequestUtils.toAbsolutePath((String)relativeUrl);
            this.getRequestCycle().setRequestTarget((IRequestTarget)new RedirectRequestTarget(absoluteUrl));
        }
    }
}

