/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.PageRegistration;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.resource.ContextRelativeResource;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class ProjectsPage
extends RootPage {
    List<ProjectModel> projectModels = new ArrayList<ProjectModel>();

    public ProjectsPage() {
        this.setup(null);
    }

    public ProjectsPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    @Override
    protected boolean reusePageParameters() {
        return true;
    }

    @Override
    protected List<ProjectModel> getProjectModels() {
        UserModel user = GitBlitWebSession.get().getUser();
        List<ProjectModel> projects = GitBlit.self().getProjectModels(user, false);
        return projects;
    }

    private void setup(PageParameters params) {
        this.setupPage("", "");
        boolean authenticateView = GitBlit.getBoolean("web.authenticateViewPages", true);
        if (authenticateView && !GitBlitWebSession.get().isLoggedIn()) {
            String messageSource = GitBlit.getString("web.loginMessage", "gitblit");
            String message = this.readMarkdown(messageSource, "login.mkd");
            Label repositoriesMessage = new Label("projectsMessage", message);
            this.add(new Component[]{repositoriesMessage.setEscapeModelStrings(false)});
            this.add(new Component[]{new Label("projectsPanel")});
            return;
        }
        String messageSource = GitBlit.getString("web.repositoriesMessage", "gitblit");
        String message = this.readMarkdown(messageSource, "welcome.mkd");
        Component projectsMessage = new Label("projectsMessage", message).setEscapeModelStrings(false).setVisible(message.length() > 0);
        this.add(new Component[]{projectsMessage});
        List<ProjectModel> projects = this.getProjects(params);
        ListDataProvider dp = new ListDataProvider(projects);
        DataView<ProjectModel> dataView = new DataView<ProjectModel>("project", (IDataProvider)dp){
            private static final long serialVersionUID = 1L;
            int counter;

            protected void onBeforeRender() {
                super.onBeforeRender();
                this.counter = 0;
            }

            public void populateItem(Item<ProjectModel> item) {
                ProjectModel entry = (ProjectModel)item.getModelObject();
                PageParameters pp = WicketUtils.newProjectParameter(entry.name);
                item.add(new Component[]{new LinkPanel("projectTitle", "list", entry.getDisplayName(), ProjectPage.class, pp)});
                item.add(new Component[]{new LinkPanel("projectDescription", "list", entry.description, ProjectPage.class, pp)});
                item.add(new Component[]{new Label("repositoryCount", entry.repositories.size() + " " + (entry.repositories.size() == 1 ? this.getString("gb.repository") : this.getString("gb.repositories")))});
                String lastChange = entry.lastChange.getTime() == 0L ? "--" : ProjectsPage.this.getTimeUtils().timeAgo(entry.lastChange);
                Label lastChangeLabel = new Label("projectLastChange", lastChange);
                item.add(new Component[]{lastChangeLabel});
                WicketUtils.setCssClass((Component)lastChangeLabel, ProjectsPage.this.getTimeUtils().timeAgoCss(entry.lastChange));
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{dataView});
        if (!this.showAdmin && !projectsMessage.isVisible()) {
            WicketUtils.setCssStyle((Component)dataView, "padding-top:5px;");
        }
    }

    @Override
    protected void addDropDownMenus(List<PageRegistration> pages) {
        PageParameters params = this.getPageParameters();
        pages.add(0, new PageRegistration("gb.projects", ProjectsPage.class, params));
        PageRegistration.DropDownMenuRegistration menu = new PageRegistration.DropDownMenuRegistration("gb.filters", ProjectsPage.class);
        menu.menuItems.addAll(this.getRepositoryFilterItems(params));
        menu.menuItems.addAll(this.getTimeFilterItems(params));
        if (menu.menuItems.size() > 0) {
            menu.menuItems.add(new PageRegistration.DropDownMenuItem(this.getString("gb.reset"), null, null));
        }
        pages.add(menu);
    }

    private String readMarkdown(String messageSource, String resource) {
        String message = "";
        if (messageSource.equalsIgnoreCase("gitblit")) {
            message = this.readDefaultMarkdown(resource);
        } else if (!StringUtils.isEmpty(messageSource)) {
            File file = new File(messageSource);
            if (file.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(file);
                    InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
                    message = MarkdownUtils.transformMarkdown(reader);
                    reader.close();
                }
                catch (Throwable t) {
                    message = this.getString("gb.failedToRead") + " " + file;
                    this.warn(message, t);
                }
            } else {
                message = messageSource + " " + this.getString("gb.isNotValidFile");
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readDefaultMarkdown(String file) {
        String base = file.substring(0, file.lastIndexOf(46));
        String ext = file.substring(file.lastIndexOf(46));
        String lc = this.getLanguageCode();
        String cc = this.getCountryCode();
        ArrayList<String> files = new ArrayList<String>();
        if (!StringUtils.isEmpty(lc)) {
            if (!StringUtils.isEmpty(cc)) {
                files.add(base + "_" + lc + "-" + cc + ext);
                files.add(base + "_" + lc + "_" + cc + ext);
            }
            files.add(base + "_" + lc + ext);
        }
        files.add(file);
        for (String name : files) {
            String string;
            InputStreamReader reader;
            block19: {
                reader = null;
                ContextRelativeResource res = WicketUtils.getResource(name);
                InputStream is = res.getResourceStream().getInputStream();
                reader = new InputStreamReader(is, "UTF-8");
                String message = MarkdownUtils.transformMarkdown(reader);
                reader.close();
                string = message;
                if (reader == null) break block19;
                try {
                    reader.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return string;
            catch (ResourceStreamNotFoundException t) {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (Exception e) {}
                continue;
            }
            catch (Throwable t) {
                String message = MessageFormat.format(this.getString("gb.failedToReadMessage"), file);
                this.error(message, t, false);
                String string2 = message;
                return string2;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        return MessageFormat.format(this.getString("gb.failedToReadMessage"), file);
    }
}

