/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.RawPage;
import com.gitblit.wicket.pages.RepositoryPage;
import java.text.MessageFormat;
import java.text.ParseException;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class MarkdownPage
extends RepositoryPage {
    public MarkdownPage(PageParameters params) {
        super(params);
        String htmlText;
        String markdownPath = WicketUtils.getPath(params);
        Repository r = this.getRepository();
        RevCommit commit = JGitUtils.getCommit(r, this.objectId);
        String[] encodings = GitBlit.getEncodings();
        this.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, markdownPath))});
        this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, markdownPath))});
        this.add(new Component[]{new BookmarkablePageLink("rawLink", RawPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, markdownPath))});
        this.add(new Component[]{new BookmarkablePageLink("headLink", MarkdownPage.class, WicketUtils.newPathParameter(this.repositoryName, "HEAD", markdownPath))});
        String markdownText = JGitUtils.getStringContent(r, commit.getTree(), markdownPath, encodings);
        try {
            htmlText = MarkdownUtils.transformMarkdown(markdownText);
        }
        catch (ParseException p) {
            markdownText = MessageFormat.format("<div class=\"alert alert-error\"><strong>{0}:</strong> {1}</div>{2}", this.getString("gb.error"), this.getString("gb.markdownFailure"), markdownText);
            htmlText = StringUtils.breakLinesForHtml(markdownText);
        }
        this.add(new Component[]{new Label("markdownText", htmlText).setEscapeModelStrings(false)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.markdown");
    }
}

