/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.SearchResult;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.SessionlessForm;
import com.gitblit.wicket.StringChoiceRenderer;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.LogPage;
import com.gitblit.wicket.pages.RootPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.TagPage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.PagerPanel;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LuceneSearchPage
extends RootPage {
    public LuceneSearchPage() {
        this.setup(null);
    }

    public LuceneSearchPage(PageParameters params) {
        super(params);
        this.setup(params);
    }

    private void setup(PageParameters params) {
        this.setupPage("", "");
        ArrayList<String> repositories = new ArrayList<String>();
        String query = "";
        int page = 1;
        int pageSize = GitBlit.getInteger("web.itemsPerPage", 50);
        if (params != null) {
            String value;
            String repository = WicketUtils.getRepositoryName(params);
            if (!StringUtils.isEmpty(repository)) {
                repositories.add(repository);
            }
            page = WicketUtils.getPage(params);
            if (params.containsKey((Object)"repositories")) {
                value = params.getString("repositories", "");
                List<String> list = StringUtils.getStringsFromValue(value);
                repositories.addAll(list);
            }
            if (params.containsKey((Object)"query")) {
                query = params.getString("query", "");
            } else {
                value = WicketUtils.getSearchString(params);
                String type = WicketUtils.getSearchType(params);
                Constants.SearchType searchType = Constants.SearchType.forName(type);
                if (!StringUtils.isEmpty(value)) {
                    query = searchType == Constants.SearchType.COMMIT ? "type:" + searchType.name().toLowerCase() + " AND \"" + value + "\"" : searchType.name().toLowerCase() + ":\"" + value + "\"";
                }
            }
        }
        UserModel user = GitBlitWebSession.get().getUser();
        ArrayList<String> availableRepositories = new ArrayList<String>();
        for (RepositoryModel model : GitBlit.self().getRepositoryModels(user)) {
            if (!model.hasCommits || ArrayUtils.isEmpty(model.indexedBranches)) continue;
            availableRepositories.add(model.name);
        }
        boolean luceneEnabled = GitBlit.getBoolean("web.allowLuceneIndexing", true);
        if (luceneEnabled) {
            if (availableRepositories.size() == 0) {
                this.info(this.getString("gb.noIndexedRepositoriesWarning"));
            }
        } else {
            this.error((Serializable)((Object)this.getString("gb.luceneDisabled")));
        }
        ArrayList<String> searchRepositories = new ArrayList<String>();
        for (String selectedRepository : repositories) {
            if (!availableRepositories.contains(selectedRepository)) continue;
            searchRepositories.add(selectedRepository);
        }
        final Model queryModel = new Model((Serializable)((Object)query));
        final Model repositoriesModel = new Model(searchRepositories);
        SessionlessForm<Void> form = new SessionlessForm<Void>("searchForm", ((Object)((Object)this)).getClass()){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                String q = (String)((Object)queryModel.getObject());
                if (StringUtils.isEmpty(q)) {
                    this.error((Serializable)((Object)this.getString("gb.undefinedQueryWarning")));
                    return;
                }
                if (((ArrayList)repositoriesModel.getObject()).size() == 0) {
                    this.error((Serializable)((Object)this.getString("gb.noSelectedRepositoriesWarning")));
                    return;
                }
                PageParameters params = new PageParameters();
                params.put("repositories", (Object)StringUtils.flattenStrings((Collection)((Object)repositoriesModel.getObject())));
                params.put("query", (Object)queryModel.getObject());
                LuceneSearchPage page = new LuceneSearchPage(params);
                this.setResponsePage((Page)page);
            }
        };
        ListMultipleChoice selections = new ListMultipleChoice("repositories", (IModel)repositoriesModel, availableRepositories, (IChoiceRenderer)new StringChoiceRenderer());
        selections.setMaxRows(8);
        form.add(new Component[]{selections.setEnabled(luceneEnabled)});
        form.add(new Component[]{new TextField("query", (IModel)queryModel).setEnabled(luceneEnabled)});
        this.add(new Component[]{form.setEnabled(luceneEnabled)});
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (!ArrayUtils.isEmpty(searchRepositories) && !StringUtils.isEmpty(query)) {
            results.addAll(GitBlit.self().search(query, page, pageSize, searchRepositories));
        }
        if (results.size() == 0) {
            if (!ArrayUtils.isEmpty(searchRepositories) && !StringUtils.isEmpty(query)) {
                this.add(new Component[]{new Label("resultsHeader", query).setRenderBodyOnly(true)});
                this.add(new Component[]{new Label("resultsCount", this.getString("gb.noHits")).setRenderBodyOnly(true)});
            } else {
                this.add(new Component[]{new Label("resultsHeader").setVisible(false)});
                this.add(new Component[]{new Label("resultsCount").setVisible(false)});
            }
        } else {
            this.add(new Component[]{new Label("resultsHeader", query).setRenderBodyOnly(true)});
            this.add(new Component[]{new Label("resultsCount", MessageFormat.format(this.getString("gb.queryResults"), ((SearchResult)results.get((int)0)).hitId, ((SearchResult)results.get((int)(results.size() - 1))).hitId, ((SearchResult)results.get((int)0)).totalHits)).setRenderBodyOnly(true)});
        }
        ListDataProvider resultsDp = new ListDataProvider(results);
        DataView<SearchResult> resultsView = new DataView<SearchResult>("searchResults", (IDataProvider)resultsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<SearchResult> item) {
                final SearchResult sr = (SearchResult)item.getModelObject();
                switch (sr.type) {
                    case commit: {
                        Label icon = WicketUtils.newIcon("type", "icon-refresh");
                        WicketUtils.setHtmlTooltip((Component)icon, "commit");
                        item.add(new Component[]{icon});
                        item.add(new Component[]{new LinkPanel("summary", null, sr.summary, CommitPage.class, WicketUtils.newObjectParameter(sr.repository, sr.commitId))});
                        Fragment fragment = new Fragment("tags", "tagsPanel", (MarkupContainer)LuceneSearchPage.this);
                        List<String> tags = sr.tags;
                        if (tags == null) {
                            tags = new ArrayList<String>();
                        }
                        ListDataProvider tagsDp = new ListDataProvider(tags);
                        DataView<String> tagsView = new DataView<String>("tag", (IDataProvider)tagsDp){
                            private static final long serialVersionUID = 1L;

                            public void populateItem(Item<String> item) {
                                String tag = (String)item.getModelObject();
                                LinkPanel c = new LinkPanel("tagLink", null, tag, TagPage.class, WicketUtils.newObjectParameter(sr.repository, "refs/tags/" + tag));
                                WicketUtils.setCssClass((Component)c, "tagRef");
                                item.add(new Component[]{c});
                            }
                        };
                        fragment.add(new Component[]{tagsView});
                        item.add(new Component[]{fragment});
                        break;
                    }
                    case blob: {
                        Label icon = WicketUtils.newIcon("type", "icon-file");
                        WicketUtils.setHtmlTooltip((Component)icon, "blob");
                        item.add(new Component[]{icon});
                        item.add(new Component[]{new LinkPanel("summary", null, sr.path, BlobPage.class, WicketUtils.newPathParameter(sr.repository, sr.branch, sr.path))});
                        item.add(new Component[]{new Label("tags").setVisible(false)});
                        break;
                    }
                    case issue: {
                        Label icon = WicketUtils.newIcon("type", "icon-file");
                        WicketUtils.setHtmlTooltip((Component)icon, "issue");
                        item.add(new Component[]{icon});
                        item.add(new Component[]{new Label("summary", "issue: " + sr.issueId)});
                        item.add(new Component[]{new Label("tags").setVisible(false)});
                        break;
                    }
                }
                item.add(new Component[]{new Label("fragment", sr.fragment).setEscapeModelStrings(false).setVisible(!StringUtils.isEmpty(sr.fragment))});
                item.add(new Component[]{new LinkPanel("repository", null, sr.repository, SummaryPage.class, WicketUtils.newRepositoryParameter(sr.repository))});
                if (StringUtils.isEmpty(sr.branch)) {
                    item.add(new Component[]{new Label("branch", "null")});
                } else {
                    item.add(new Component[]{new LinkPanel("branch", "branch", StringUtils.getRelativePath("refs/heads/", sr.branch), LogPage.class, WicketUtils.newObjectParameter(sr.repository, sr.branch))});
                }
                item.add(new Component[]{new Label("author", sr.author)});
                item.add(new Component[]{WicketUtils.createDatestampLabel("date", sr.date, LuceneSearchPage.this.getTimeZone(), LuceneSearchPage.this.getTimeUtils())});
            }
        };
        this.add(new Component[]{resultsView.setVisible(results.size() > 0)});
        PageParameters pagerParams = new PageParameters();
        pagerParams.put("repositories", (Object)StringUtils.flattenStrings((Collection)((Object)repositoriesModel.getObject())));
        pagerParams.put("query", (Object)queryModel.getObject());
        boolean showPager = false;
        int totalPages = 0;
        if (results.size() > 0) {
            totalPages = ((SearchResult)results.get((int)0)).totalHits / pageSize + (((SearchResult)results.get((int)0)).totalHits % pageSize > 0 ? 1 : 0);
            showPager = ((SearchResult)results.get((int)0)).totalHits > pageSize;
        }
        this.add(new Component[]{new PagerPanel("topPager", page, totalPages, LuceneSearchPage.class, pagerParams).setVisible(showPager)});
        this.add(new Component[]{new PagerPanel("bottomPager", page, totalPages, LuceneSearchPage.class, pagerParams).setVisible(showPager)});
    }
}

