/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.models.GravatarProfile;
import com.gitblit.utils.ActivityUtils;
import com.gitblit.wicket.ExternalImage;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RootPage;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;

public class GravatarProfilePage
extends RootPage {
    public GravatarProfilePage(PageParameters params) {
        this.setupPage("", "");
        String object = WicketUtils.getObject(params);
        GravatarProfile profile = null;
        try {
            profile = object.indexOf(64) > -1 ? ActivityUtils.getGravatarProfileFromAddress(object) : ActivityUtils.getGravatarProfile(object);
        }
        catch (IOException e) {
            this.error(MessageFormat.format(this.getString("gb.failedToFindGravatarProfile"), object), e, true);
        }
        if (profile == null) {
            this.error(MessageFormat.format(this.getString("gb.failedToFindGravatarProfile"), object), true);
        }
        this.add(new Component[]{new Label("displayName", profile.displayName)});
        this.add(new Component[]{new Label("username", profile.preferredUsername)});
        this.add(new Component[]{new Label("location", profile.currentLocation)});
        this.add(new Component[]{new Label("aboutMe", profile.aboutMe)});
        ExternalImage image = new ExternalImage("profileImage", profile.thumbnailUrl + "?s=256&d=identicon");
        this.add(new Component[]{image});
        this.add(new Component[]{new ExternalLink("profileLink", profile.profileUrl)});
    }
}

