/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.ForkModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.ProjectPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import com.gitblit.wicket.pages.UserPage;
import com.gitblit.wicket.panels.GravatarImage;
import com.gitblit.wicket.panels.LinkPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.PersonIdent;

public class ForksPage
extends RepositoryPage {
    public ForksPage(PageParameters params) {
        super(params);
        final RepositoryModel pageRepository = this.getRepositoryModel();
        ForkModel root = GitBlit.self().getForkNetwork(pageRepository.name);
        List<FlatFork> network = this.flatten(root);
        ListDataProvider forksDp = new ListDataProvider(network);
        DataView<FlatFork> forksList = new DataView<FlatFork>("fork", (IDataProvider)forksDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<FlatFork> item) {
                FlatFork fork = (FlatFork)item.getModelObject();
                RepositoryModel repository = fork.repository;
                if (repository.isPersonalRepository()) {
                    UserModel user = GitBlit.self().getUserModel(repository.projectPath.substring(1));
                    PersonIdent ident = new PersonIdent(user.getDisplayName(), user.emailAddress == null ? user.getDisplayName() : user.emailAddress);
                    item.add(new Component[]{new GravatarImage("anAvatar", ident, 20)});
                    if (pageRepository.equals(repository)) {
                        item.add(new Component[]{new Label("aProject", user.getDisplayName())});
                    } else {
                        item.add(new Component[]{new LinkPanel("aProject", null, user.getDisplayName(), UserPage.class, WicketUtils.newUsernameParameter(user.username))});
                    }
                } else {
                    Label swatch;
                    if (repository.isBare) {
                        swatch = new Label("anAvatar", "&nbsp;").setEscapeModelStrings(false);
                    } else {
                        swatch = new Label("anAvatar", "!");
                        WicketUtils.setHtmlTooltip((Component)swatch, this.getString("gb.workingCopyWarning"));
                    }
                    WicketUtils.setCssClass((Component)swatch, "repositorySwatch");
                    WicketUtils.setCssBackground((Component)swatch, repository.toString());
                    item.add(new Component[]{swatch});
                    String projectName = repository.projectPath;
                    if (StringUtils.isEmpty(projectName)) {
                        projectName = GitBlit.getString("web.repositoryRootGroupName", "main");
                    }
                    if (pageRepository.equals(repository)) {
                        item.add(new Component[]{new Label("aProject", projectName)});
                    } else {
                        item.add(new Component[]{new LinkPanel("aProject", null, projectName, ProjectPage.class, WicketUtils.newProjectParameter(projectName))});
                    }
                }
                String repo = StringUtils.getLastPathElement(repository.name);
                UserModel user = GitBlitWebSession.get().getUser();
                if (user == null) {
                    user = UserModel.ANONYMOUS;
                }
                if (user.canView(repository)) {
                    if (pageRepository.equals(repository)) {
                        item.add(new Component[]{new Label("aFork", StringUtils.stripDotGit(repo))});
                    } else {
                        item.add(new Component[]{new LinkPanel("aFork", null, StringUtils.stripDotGit(repo), SummaryPage.class, WicketUtils.newRepositoryParameter(repository.name))});
                    }
                    item.add(new Component[]{WicketUtils.createDateLabel("lastChange", repository.lastChange, ForksPage.this.getTimeZone(), ForksPage.this.getTimeUtils())});
                } else {
                    item.add(new Component[]{new Label("aFork", repo)});
                    item.add(new Component[]{new Label("lastChange").setVisible(false)});
                }
                WicketUtils.setCssStyle(item, "margin-left:" + 32 * fork.level + "px;");
                if (fork.level == 0) {
                    WicketUtils.setCssClass(item, "forkSource");
                } else {
                    WicketUtils.setCssClass(item, "forkEntry");
                }
            }
        };
        this.add(new Component[]{forksList});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.forks");
    }

    protected List<FlatFork> flatten(ForkModel root) {
        ArrayList<FlatFork> list = new ArrayList<FlatFork>();
        list.addAll(this.flatten(root, 0));
        return list;
    }

    protected List<FlatFork> flatten(ForkModel node, int level) {
        ArrayList<FlatFork> list = new ArrayList<FlatFork>();
        list.add(new FlatFork(node.repository, level));
        if (!node.isLeaf()) {
            for (ForkModel fork : node.forks) {
                list.addAll(this.flatten(fork, level + 1));
            }
        }
        return list;
    }

    private class FlatFork
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final RepositoryModel repository;
        public final int level;

        public FlatFork(RepositoryModel repository, int level) {
            this.repository = repository;
            this.level = level;
        }
    }
}

