/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.wicket.GitBlitWebSession;
import com.gitblit.wicket.GitblitRedirectException;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.SummaryPage;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.slf4j.LoggerFactory;

public class ForkPage
extends RepositoryPage {
    public ForkPage(PageParameters params) {
        super(params);
        this.setVersioned(false);
        GitBlitWebSession session = GitBlitWebSession.get();
        RepositoryModel repository = this.getRepositoryModel();
        UserModel user = session.getUser();
        boolean canFork = user.canFork(repository);
        if (!canFork) {
            GitBlitWebSession.get().cacheErrorMessage(MessageFormat.format(this.getString("gb.forkNotAuthorized"), repository.name));
            throw new GitblitRedirectException(SummaryPage.class, WicketUtils.newRepositoryParameter(repository.name));
        }
        String fork = GitBlit.self().getFork(user.username, repository.name);
        if (fork != null) {
            throw new GitblitRedirectException(SummaryPage.class, WicketUtils.newRepositoryParameter(fork));
        }
        this.add(new Component[]{new Label("forkText", this.getString("gb.preparingFork"))});
        if (!session.isForking()) {
            session.isForking(true);
            ForkThread forker = new ForkThread(repository, session);
            forker.start();
        }
    }

    @Override
    protected boolean allowForkControls() {
        return false;
    }

    @Override
    protected String getPageName() {
        return "fork";
    }

    private static class ForkThread
    extends Thread {
        private final RepositoryModel repository;
        private final GitBlitWebSession session;

        public ForkThread(RepositoryModel repository, GitBlitWebSession session) {
            this.repository = repository;
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UserModel user = this.session.getUser();
            try {
                GitBlit.self().fork(this.repository, user);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ForkPage.class).error(MessageFormat.format("Failed to fork {0} for {1}", this.repository.name, user.username), (Throwable)e);
            }
            finally {
                this.session.isForking(false);
            }
        }
    }
}

