/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.models.PathModel;
import com.gitblit.utils.ByteFormat;
import com.gitblit.utils.JGitUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.RawPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.LinkPanel;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.eclipse.jgit.lib.Repository;

public class DocsPage
extends RepositoryPage {
    public DocsPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        List<String> extensions = GitBlit.getStrings("web.markdownExtensions");
        List<PathModel> paths = JGitUtils.getDocuments(r, extensions);
        final ByteFormat byteFormat = new ByteFormat();
        this.add(new Component[]{new Label("header", this.getString("gb.docs"))});
        ListDataProvider pathsDp = new ListDataProvider(paths);
        DataView<PathModel> pathsView = new DataView<PathModel>("document", (IDataProvider)pathsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<PathModel> item) {
                PathModel entry = (PathModel)item.getModelObject();
                item.add(new Component[]{WicketUtils.newImage("docIcon", "file_world_16x16.png")});
                item.add(new Component[]{new Label("docSize", byteFormat.format(entry.size))});
                item.add(new Component[]{new LinkPanel("docName", "list", entry.name, BlobPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, entry.commitId, entry.path))});
                item.add(new Component[]{new BookmarkablePageLink("view", BlobPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, entry.commitId, entry.path))});
                item.add(new Component[]{new BookmarkablePageLink("raw", RawPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, entry.commitId, entry.path))});
                item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, entry.commitId, entry.path))});
                item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(DocsPage.this.repositoryName, entry.commitId, entry.path))});
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{pathsView});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.docs");
    }
}

