/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.Constants;
import com.gitblit.GitBlit;
import com.gitblit.models.GitNote;
import com.gitblit.models.PathModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.BlobDiffPage;
import com.gitblit.wicket.pages.BlobPage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.pages.TreePage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.CommitLegendPanel;
import com.gitblit.wicket.panels.CompressedDownloadsPanel;
import com.gitblit.wicket.panels.GravatarImage;
import com.gitblit.wicket.panels.LinkPanel;
import com.gitblit.wicket.panels.RefsPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.markup.repeater.data.ListDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitPage
extends RepositoryPage {
    public CommitPage(PageParameters params) {
        super(params);
        Repository r = this.getRepository();
        RevCommit c = this.getCommit();
        ArrayList<String> parents = new ArrayList<String>();
        if (c.getParentCount() > 0) {
            for (RevCommit parent : c.getParents()) {
                parents.add(parent.name());
            }
        }
        if (parents.size() == 0) {
            this.add(new Component[]{new Label("parentLink", "none")});
            this.add(new Component[]{new Label("commitdiffLink", this.getString("gb.commitdiff"))});
        } else {
            this.add(new Component[]{new LinkPanel("parentLink", null, this.getShortObjectId((String)parents.get(0)), CommitPage.class, this.newCommitParameter((String)parents.get(0)))});
            this.add(new Component[]{new LinkPanel("commitdiffLink", null, (IModel<String>)new StringResourceModel("gb.commitdiff", (Component)this, null), CommitDiffPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        }
        this.add(new Component[]{new BookmarkablePageLink("patchLink", PatchPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, c)});
        this.addRefs(r, c);
        this.add(new Component[]{this.createPersonPanel("commitAuthor", c.getAuthorIdent(), Constants.SearchType.AUTHOR)});
        this.add(new Component[]{WicketUtils.createTimestampLabel("commitAuthorDate", c.getAuthorIdent().getWhen(), this.getTimeZone(), this.getTimeUtils())});
        this.add(new Component[]{this.createPersonPanel("commitCommitter", c.getCommitterIdent(), Constants.SearchType.COMMITTER)});
        this.add(new Component[]{WicketUtils.createTimestampLabel("commitCommitterDate", c.getCommitterIdent().getWhen(), this.getTimeZone(), this.getTimeUtils())});
        this.add(new Component[]{new Label("commitId", c.getName())});
        this.add(new Component[]{new LinkPanel("commitTree", "list", c.getTree().getName(), TreePage.class, this.newCommitParameter())});
        this.add(new Component[]{new BookmarkablePageLink("treeLink", TreePage.class, this.newCommitParameter())});
        String baseUrl = WicketUtils.getGitblitURL(this.getRequest());
        this.add(new Component[]{new CompressedDownloadsPanel("compressedLinks", baseUrl, this.repositoryName, this.objectId, null)});
        ListDataProvider parentsDp = new ListDataProvider(parents);
        DataView<String> parentsView = new DataView<String>("commitParents", (IDataProvider)parentsDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<String> item) {
                String entry = (String)item.getModelObject();
                item.add(new Component[]{new LinkPanel("commitParent", "list", entry, CommitPage.class, CommitPage.this.newCommitParameter(entry))});
                item.add(new Component[]{new BookmarkablePageLink("view", CommitPage.class, CommitPage.this.newCommitParameter(entry))});
                item.add(new Component[]{new BookmarkablePageLink("diff", CommitDiffPage.class, CommitPage.this.newCommitParameter(entry))});
            }
        };
        this.add(new Component[]{parentsView});
        this.addFullText("fullMessage", c.getFullMessage(), true);
        List<GitNote> notes = JGitUtils.getNotesOnCommit(r, c);
        ListDataProvider notesDp = new ListDataProvider(notes);
        DataView<GitNote> notesView = new DataView<GitNote>("notes", (IDataProvider)notesDp){
            private static final long serialVersionUID = 1L;

            public void populateItem(Item<GitNote> item) {
                GitNote entry = (GitNote)item.getModelObject();
                item.add(new Component[]{new RefsPanel("refName", CommitPage.this.repositoryName, Arrays.asList(entry.notesRef))});
                item.add(new Component[]{CommitPage.this.createPersonPanel("authorName", entry.notesRef.getAuthorIdent(), Constants.SearchType.AUTHOR)});
                item.add(new Component[]{new GravatarImage("noteAuthorAvatar", entry.notesRef.getAuthorIdent())});
                item.add(new Component[]{WicketUtils.createTimestampLabel("authorDate", entry.notesRef.getAuthorIdent().getWhen(), CommitPage.this.getTimeZone(), CommitPage.this.getTimeUtils())});
                item.add(new Component[]{new Label("noteContent", GitBlit.self().processCommitMessage(CommitPage.this.repositoryName, entry.content)).setEscapeModelStrings(false)});
            }
        };
        this.add(new Component[]{notesView.setVisible(notes.size() > 0)});
        List<PathModel.PathChangeModel> paths = JGitUtils.getFilesInCommit(r, c);
        this.add(new Component[]{new CommitLegendPanel("commitLegend", paths)});
        ListDataProvider pathsDp = new ListDataProvider(paths);
        DataView<PathModel.PathChangeModel> pathsView = new DataView<PathModel.PathChangeModel>("changedPath", (IDataProvider)pathsDp){
            private static final long serialVersionUID = 1L;
            int counter;

            public void populateItem(Item<PathModel.PathChangeModel> item) {
                PathModel.PathChangeModel entry = (PathModel.PathChangeModel)item.getModelObject();
                Label changeType = new Label("changeType", "");
                WicketUtils.setChangeTypeCssClass((Component)changeType, entry.changeType);
                CommitPage.this.setChangeTypeTooltip((Component)changeType, entry.changeType);
                item.add(new Component[]{changeType});
                boolean hasSubmodule = false;
                String submodulePath = null;
                if (entry.isTree()) {
                    item.add(new Component[]{new LinkPanel("pathName", null, entry.path, TreePage.class, WicketUtils.newPathParameter(CommitPage.this.repositoryName, entry.commitId, entry.path))});
                } else if (entry.isSubmodule()) {
                    String submoduleId = entry.objectId;
                    SubmoduleModel submodule = CommitPage.this.getSubmodule(entry.path);
                    submodulePath = submodule.gitblitPath;
                    hasSubmodule = submodule.hasSubmodule;
                    item.add(new Component[]{new LinkPanel("pathName", "list", entry.path + " @ " + CommitPage.this.getShortObjectId(submoduleId), TreePage.class, WicketUtils.newPathParameter(submodulePath, submoduleId, "")).setEnabled(hasSubmodule)});
                } else {
                    String displayPath = entry.path;
                    String path = entry.path;
                    if (entry.isSymlink()) {
                        path = JGitUtils.getStringContent(CommitPage.this.getRepository(), CommitPage.this.getCommit().getTree(), path, new String[0]);
                        displayPath = entry.path + " -> " + path;
                    }
                    item.add(new Component[]{new LinkPanel("pathName", "list", displayPath, BlobPage.class, WicketUtils.newPathParameter(CommitPage.this.repositoryName, entry.commitId, path))});
                }
                if (entry.isSubmodule()) {
                    item.add(new Component[]{new BookmarkablePageLink("diff", BlobDiffPage.class, WicketUtils.newPathParameter(submodulePath, entry.objectId, entry.path)).setEnabled(false)});
                    item.add(new Component[]{new BookmarkablePageLink("view", CommitPage.class, WicketUtils.newObjectParameter(submodulePath, entry.objectId)).setEnabled(hasSubmodule)});
                    item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(submodulePath, entry.objectId, entry.path)).setEnabled(false)});
                    item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(submodulePath, entry.objectId, entry.path)).setEnabled(hasSubmodule)});
                } else {
                    item.add(new Component[]{new BookmarkablePageLink("diff", BlobDiffPage.class, WicketUtils.newPathParameter(CommitPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD) && !entry.changeType.equals((Object)DiffEntry.ChangeType.DELETE))});
                    item.add(new Component[]{new BookmarkablePageLink("view", BlobPage.class, WicketUtils.newPathParameter(CommitPage.this.repositoryName, entry.commitId, entry.path))});
                    item.add(new Component[]{new BookmarkablePageLink("blame", BlamePage.class, WicketUtils.newPathParameter(CommitPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                    item.add(new Component[]{new BookmarkablePageLink("history", HistoryPage.class, WicketUtils.newPathParameter(CommitPage.this.repositoryName, entry.commitId, entry.path)).setEnabled(!entry.changeType.equals((Object)DiffEntry.ChangeType.ADD))});
                }
                WicketUtils.setAlternatingBackground(item, this.counter);
                ++this.counter;
            }
        };
        this.add(new Component[]{pathsView});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.commit");
    }
}

