/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.pages;

import com.gitblit.GitBlit;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.WicketUtils;
import com.gitblit.wicket.pages.BlamePage;
import com.gitblit.wicket.pages.CommitDiffPage;
import com.gitblit.wicket.pages.CommitPage;
import com.gitblit.wicket.pages.HistoryPage;
import com.gitblit.wicket.pages.PatchPage;
import com.gitblit.wicket.pages.RepositoryPage;
import com.gitblit.wicket.panels.CommitHeaderPanel;
import com.gitblit.wicket.panels.PathBreadcrumbsPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class BlobDiffPage
extends RepositoryPage {
    public BlobDiffPage(PageParameters params) {
        super(params);
        String diff;
        String blobPath = WicketUtils.getPath(params);
        String baseObjectId = WicketUtils.getBaseObjectId(params);
        Repository r = this.getRepository();
        RevCommit commit = this.getCommit();
        DiffUtils.DiffOutputType diffType = DiffUtils.DiffOutputType.forName(GitBlit.getString("web.diffStyle", DiffUtils.DiffOutputType.GITBLIT.name()));
        if (StringUtils.isEmpty(baseObjectId)) {
            diff = DiffUtils.getDiff(r, commit, blobPath, diffType);
            this.add(new Component[]{new BookmarkablePageLink("patchLink", PatchPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        } else {
            RevCommit baseCommit = JGitUtils.getCommit(r, baseObjectId);
            diff = DiffUtils.getDiff(r, baseCommit, commit, blobPath, diffType);
            this.add(new Component[]{new BookmarkablePageLink("patchLink", PatchPage.class, WicketUtils.newBlobDiffParameter(this.repositoryName, baseObjectId, this.objectId, blobPath))});
        }
        this.add(new Component[]{new BookmarkablePageLink("commitLink", CommitPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("commitDiffLink", CommitDiffPage.class, WicketUtils.newObjectParameter(this.repositoryName, this.objectId))});
        this.add(new Component[]{new BookmarkablePageLink("blameLink", BlamePage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        this.add(new Component[]{new BookmarkablePageLink("historyLink", HistoryPage.class, WicketUtils.newPathParameter(this.repositoryName, this.objectId, blobPath))});
        this.add(new Component[]{new CommitHeaderPanel("commitHeader", this.repositoryName, commit)});
        this.add(new Component[]{new PathBreadcrumbsPanel("breadcrumbs", this.repositoryName, blobPath, this.objectId)});
        this.add(new Component[]{new Label("diffText", diff).setEscapeModelStrings(false)});
    }

    @Override
    protected String getPageName() {
        return this.getString("gb.diff");
    }
}

