/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.wicket.charting;

import com.gitblit.wicket.charting.GoogleChart;
import java.text.MessageFormat;

public class GoogleLineChart
extends GoogleChart {
    private static final long serialVersionUID = 1L;

    public GoogleLineChart(String tagId, String title, String keyName, String valueName) {
        super(tagId, title, keyName, valueName);
    }

    @Override
    protected void appendChart(StringBuilder sb) {
        String dName = "data_" + this.dataName;
        this.line(sb, MessageFormat.format("var {0} = new google.visualization.DataTable();", dName));
        this.line(sb, MessageFormat.format("{0}.addColumn(''string'', ''{1}'');", dName, this.keyName));
        this.line(sb, MessageFormat.format("{0}.addColumn(''number'', ''{1}'');", dName, this.valueName));
        this.line(sb, MessageFormat.format("{0}.addRows({1,number,0});", dName, this.values.size()));
        for (int i = 0; i < this.values.size(); ++i) {
            GoogleChart.ChartValue value = (GoogleChart.ChartValue)this.values.get(i);
            this.line(sb, MessageFormat.format("{0}.setValue({1,number,0}, 0, ''{2}'');", dName, i, value.name));
            this.line(sb, MessageFormat.format("{0}.setValue({1,number,0}, 1, {2,number,0.0});", dName, i, Float.valueOf(value.value)));
        }
        String cName = "chart_" + this.dataName;
        this.line(sb, MessageFormat.format("var {0} = new google.visualization.LineChart(document.getElementById(''{1}''));", cName, this.tagId));
        this.line(sb, MessageFormat.format("{0}.draw({1}, '{'width: {2,number,0}, height: {3,number,0}, pointSize: 4, chartArea:'{'left:20,top:20'}', vAxis: '{' textPosition: ''none'' '}', legend: ''none'', title: ''{4}'' '}');", cName, dName, this.width, this.height, this.title));
        this.line(sb, "");
    }
}

